/*
 * Decompiled with CFR 0.152.
 */
package com.ghc.ghTester.ant;

import com.ghc.ini.IniFile;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

class CommandLineBuilder {
    private static final String VMARGS = "-vmargs";
    private static final String LICENCE = "-licence";
    private static final String PARAMETER_FILE = "-parameterFile";
    private static final String RESULTS_SERVER_LOGGING = "-resultsServerLogging";
    private static final String INPUT = "-input";
    private static final String OUTPUT = "-output";
    private final String applicationPath;
    private String licence;
    private String resultServerLogging;
    private String parameterFilePath;
    private String input;
    private String output;
    private List<String> scriptArgs;
    private File file;
    private String command;
    private String priorArg;

    public CommandLineBuilder(String command, File applicationFile) {
        this(applicationFile);
        this.command = command;
    }

    public CommandLineBuilder(File applicationFile) {
        this.applicationPath = applicationFile.getAbsolutePath();
    }

    public CommandLineBuilder withLicence(String licence) {
        this.licence = licence;
        return this;
    }

    public CommandLineBuilder withResultsServerLogging(String resultServerLogging) {
        this.resultServerLogging = resultServerLogging;
        return this;
    }

    public CommandLineBuilder withParameterFile(File parameterFile) {
        this.parameterFilePath = parameterFile.getAbsolutePath();
        return this;
    }

    public CommandLineBuilder withInput(String input) {
        this.input = input;
        return this;
    }

    public CommandLineBuilder withOutput(String output) {
        this.output = output;
        return this;
    }

    public CommandLineBuilder withVmArgs(List<String> scriptArgs, File file) {
        this.scriptArgs = scriptArgs;
        this.file = file;
        return this;
    }

    public CommandLineBuilder withPriorArg(String priorArg) {
        this.priorArg = priorArg;
        return this;
    }

    public String[] build() {
        ArrayList<String> args = new ArrayList<String>();
        if (this.command != null) {
            args.add(this.command);
        }
        args.add(this.applicationPath);
        if (this.priorArg != null) {
            args.add(this.priorArg);
        }
        if (this.licence != null) {
            args.add(LICENCE);
            args.add(this.licence);
        }
        if (this.resultServerLogging != null) {
            args.add(RESULTS_SERVER_LOGGING);
            args.add(this.resultServerLogging);
        }
        if (this.parameterFilePath != null) {
            args.add(PARAMETER_FILE);
            args.add(this.parameterFilePath);
        }
        if (this.input != null) {
            args.add(INPUT);
            args.add(this.input);
        }
        if (this.output != null) {
            args.add(OUTPUT);
            args.add(this.output);
        }
        if (this.scriptArgs != null && !this.scriptArgs.isEmpty()) {
            args.add(VMARGS);
            if (this.file != null && this.file.exists()) {
                IniFile iniFile = new IniFile(this.file);
                for (String arg : this.scriptArgs) {
                    iniFile.addJvmArgument(arg);
                }
                args.addAll(iniFile.getJvmArguments());
            } else {
                args.addAll(this.scriptArgs);
            }
        }
        return args.toArray(new String[args.size()]);
    }
}

