/*
 * Decompiled with CFR 0.152.
 */
package com.ghc.ghTester.ant;

import com.ghc.ghTester.ant.vie.stubs.environment.EnvironmentLocker;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class LockEnvironment
extends Task {
    private boolean haltOnFailure = false;
    private String failureProperty = null;
    private String serverURL;
    private String domain;
    private String environment;
    private String username;
    private String duration;
    private String force;
    private String reason;
    private String waitFor;

    public void execute() throws BuildException {
        this.validateInputs();
        int exitCode = this.lockEnvironment();
        if (this.haltOnFailure && exitCode != 0) {
            throw new BuildException("LockEnvironment exited with code " + exitCode);
        }
        if (this.failureProperty != null && exitCode != 0) {
            this.getProject().setNewProperty(this.failureProperty, "true");
        }
        this.log("LockEnvironment exited with code " + exitCode, 2);
    }

    private void validateInputs() throws BuildException {
        if (this.domain == null) {
            throw new BuildException("Domain must be specified");
        }
        if (this.environment == null) {
            throw new BuildException("Environment must be specified");
        }
        if (this.serverURL == null) {
            throw new BuildException("Server URL must be specified");
        }
        if (this.username == null) {
            throw new BuildException("Username must be specified");
        }
    }

    private int lockEnvironment() throws BuildException {
        try {
            EnvironmentLocker locker = new EnvironmentLocker(this.serverURL, this.domain, this.environment, this.username, this.duration, this.reason, this.force != null ? Boolean.parseBoolean(this.force) : false);
            return locker.lock((String)this.waitFor).code;
        }
        catch (NumberFormatException numberFormatException) {
            throw new BuildException("If duration or waitFor are supplied they must be a number");
        }
        catch (Exception e) {
            throw new BuildException("An error occurred while running LockEnvironment", (Throwable)e);
        }
    }

    public void setHaltOnFailure(boolean haltOnError) {
        this.haltOnFailure = haltOnError;
    }

    public void setFailureProperty(String value) {
        this.failureProperty = value;
    }

    public void setServerURL(String serverURL) {
        this.serverURL = serverURL;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setDuration(String duration) {
        this.duration = duration;
    }

    public void setWaitFor(String waitFor) {
        this.waitFor = waitFor;
    }

    public void setForce(String force) {
        this.force = force;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }
}

