package com.urbancode.air.plugin.rtw

import com.urbancode.air.CommandHelper
import java.util.regex.Matcher
import java.util.regex.Pattern

public class RTWProductHelper {
	
	def ENV_VAR_SDP_DIR = "TEST_WORKBENCH_HOME"; //$NON-NLS-1$
	// Mandatory Options for Test Execution
	def workspace ;
	def project ;
	def suite ;
	
	// Read non-mandatory fields
	def imsharedloc ;
	def varfile ;
	def configfile;
	def results ;
	def overwrite ;
	def users ;
	def vmargs ;
	def exportlog ;
	def exportstats ;
	def exportstatreportlist ;
	def usercomments ;
	def swapdatasets ;
	def overridermlabels;
	def rate;
	def duration;
	def exportstatshtml;
	def exportstatsformat;
	def publish;
	def publish_for;
	def publishreports;
	def history;
	def product = RTWProduct.RPT;
	def eclipsehome = "";
	def plugins="";
	def labels="";
	
	def cmdHelper = new CommandLineHelper();
	
	RTWProductHelper(def props,RTWProduct prod) {
		printProps(props);
		product = prod;
		
		workspace = props['workspace'];
		project = props['project'];
		suite = props['suite'];
		
		// Read non-mandatory fields
		imsharedloc = props['imsharedloc'];
		varfile = props['varfile'];
		configfile = props['configfile'];
		results = props['results'];
		overwrite = props['overwrite'];
		labels = props['labels'];
		if(prod==RTWProduct.RPT){
			// We may have to remove users and usercomments from the UI for RTWec test
			// whenever I passed users from command line it threw NullpointerException and comments 
			// cannot be seen anywhere. Discussed with Siva.
			users = props['users'];
			usercomments = props['usercomments'];
		}
		vmargs = props['vmargs'];
		swapdatasets = props['swapdatasets'];
		overridermlabels = props['overridermlabels'];
		exportlog = props['exportlog'];
		exportstats = props['exportstats'];
		exportstatreportlist = props['exportstatreportlist'];
		rate = props['rate'];
		duration = props['duration'];
		exportstatshtml = props['exportstatshtml'];
		exportstatsformat = props['exportstatsformat'];
		publish = props['publish'];
		publish_for = props['publish_for'];
		publishreports = props['publishreports'];
		history = props['history'];
		
		
	}
	
	final def workDir = new File('.').canonicalFile
	
	def printProps(def props){
		println "Working Directory = "+workDir;
		
		println "Printing Step Properties ....";
		
		def propKeys = props.keys();
		while(propKeys.hasMoreElements()){
			def key = propKeys.nextElement();
			def val = props.get(key);
			println key+" = "+val;
		}
	}
	
	
	def validateInputs(){
		
		try{
			// First validate all values input by the User
			def fWorkspace = new File(workspace);
			if (!fWorkspace.exists()) {
				throw new RuntimeException("Invalid Workspace location :"+workspace);
			}
			
			def projectPath = workspace + File.separator + project;
			println "Project Path" + projectPath;
		
			if(varfile.toString().trim().length() > 0){
				def fVarfile = new File(varfile);
				if (!fVarfile.exists()) {
					throw new RuntimeException("Invalid Var File location :"+varfile);
				}
			}
			
			if(configfile.toString().trim().length() > 0){
				def fConfigfile = new File(configfile);
				if (!fConfigfile.exists()) {
					throw new Exception("Invalid Config File location :"+configfile);
				}
			}
			
			if(exportlog.toString().trim().length() > 0){
				def fExportlog = new File(exportlog);
				if (fExportlog.exists()) {
					def delStatus = fExportlog.delete();
					//println "Deleted existing file successfully "+delStatus.toString();
				}
			}else{
				// set default export log file
				exportlog = workDir.toString()+File.separator+"temp"+ File.separator+ suite+".exportlog.log";
			}
				
		}catch(Exception ex){
			println "Error:"+ex.message;
			System.exit(1);
		}
	}
	
	def runTest(def mainOutProps){
		if(configfile == null && configfile.toString().isEmpty())
		{
		validateInputs();
		}
		initIMData();
		executeTest(mainOutProps);
	}
	
	
	def executeTest(def mainOutProps){
		try {
			def isWindows = (System.getProperty('os.name') =~ /(?i)windows/).find()
			def out = System.out;
			def batchFileName = isWindows ? "cmdline.bat" : "cmdline.sh"
			def dirCmdline = eclipsehome + File.separator +"cmdline";
			
			println "cmdline directory path " + dirCmdline;
			def dirBatchFilePath = dirCmdline+File.separator+ batchFileName;

			def fdirBatchFile = new File(dirBatchFilePath);
			if (!fdirBatchFile.exists()) {
				throw new RuntimeException("Invalid Commandline batch file location :"+dirBatchFilePath);
			}
			def ch = new CommandHelper(new File(dirCmdline))

			// Build args
			def cmdArgs = [];
			def arg="";
			if(configfile != null && !configfile.toString().isEmpty())
				{
					cmdArgs = [dirBatchFilePath];
					arg = '-configfile';
					cmdArgs << arg;
					cmdArgs << configfile;
				}
			else
			{	
				if((workspace == null || workspace.toString().isEmpty()) &&	(project == null || project.toString().isEmpty()) &&
					(suite == null || suite.toString().isEmpty()))
				{
					throw new RuntimeException("Workspace,Project, & Suite are mandatory parameter :");
				}
				cmdArgs = [dirBatchFilePath, '-workspace', workspace, '-project', project, '-plugins', plugins, '-eclipsehome', eclipsehome, '-suite', suite];
				
				if(varfile != null && !varfile.toString().isEmpty())
				{
					arg = '-varfile';
					cmdArgs << arg;
					cmdArgs << varfile;
				}
	
	
				if(vmargs != null && !vmargs.toString().isEmpty())
				{
					arg = '-vmargs';
					cmdArgs << arg;
					cmdArgs << vmargs;
				}
				
				if(swapdatasets != null && !swapdatasets.toString().isEmpty())
				{
					arg = '-swapdatasets';
					cmdArgs << arg;
					cmdArgs << swapdatasets;
				}
				
				if(overridermlabels != null && !overridermlabels.toString().isEmpty())
				{
					arg = '-overridermlabels';
					cmdArgs << arg;
					cmdArgs << overridermlabels;
				}
				
				if(exportlog != null && !exportlog.toString().isEmpty())
				{
					arg = '-exportlog';
					cmdArgs << arg;
					cmdArgs << exportlog;
				}
	
				if(labels != null && !labels.toString().isEmpty())
				{
					arg = '-labels';
					cmdArgs << arg;
					cmdArgs << labels;
				}
	
				if(exportstats != null && !exportstats.toString().isEmpty())
				{
					arg = '-exportstats';
					cmdArgs << arg;
					cmdArgs << exportstats;
				}
	
				if(exportstatreportlist != null && !exportstatreportlist.toString().isEmpty())
				{
					arg = '-exportstatreportlist';
					cmdArgs << arg;
					cmdArgs << exportstatreportlist;
				}
				
				if(results != null && !results.toString().isEmpty())
				{
					arg = '-results';
					cmdArgs << arg;
					cmdArgs << results;
				}
				
				if(users != null && !users.toString().isEmpty())
				{
					arg = '-users';
					cmdArgs << arg;
					cmdArgs << users;
				}
				 
				if(usercomments != null && !usercomments.toString().isEmpty())
				{
					arg = '-usercomments';
					cmdArgs << arg;
					cmdArgs << usercomments;
				}
				
				if(overwrite=="true")
				{
					arg = '-overwrite';
					cmdArgs << arg;
					cmdArgs << overwrite;
				}
				
				if(rate != null && !rate.toString().isEmpty())
				{
					arg = '-rate';
					cmdArgs << arg;
					cmdArgs << rate;
				}
				if(duration != null && !duration.toString().isEmpty())
				{
					arg = '-duration';
					cmdArgs << arg;
					cmdArgs << duration;
				}
				if(exportstatshtml != null && !exportstatshtml.toString().isEmpty())
				{
					arg = '-exportstatshtml';
					cmdArgs << arg;
					cmdArgs << exportstatshtml;
				}
				if(exportstatsformat != null && !exportstatsformat.toString().isEmpty())
				{
					arg = '-exportstatsformat';
					cmdArgs << arg;
					cmdArgs << exportstatsformat;
				}
				if(publish != null && !publish.toString().isEmpty())
				{   arg = '-publish';
					cmdArgs << arg;
					if(isWindows) {
						cmdArgs << "\"" + publish.toString() + "\"";
					} else {
						cmdArgs << publish.toString();
					}
				}
				if(publish_for != null && !publish_for.toString().isEmpty())
				{
					arg = '-publish_for';
					cmdArgs << arg;
					cmdArgs << publish_for;
				}
				if(publishreports != null && !publishreports.toString().isEmpty())
				{
					arg = '-publishreports';
					cmdArgs << arg;
					cmdArgs << publishreports;
				}
				if(history != null && !history.toString().isEmpty())
				{
					arg = '-history';
					cmdArgs << arg;
					cmdArgs << history;
				}
			}
			ch.runCommand("Running test..", cmdArgs);

			def outputProps = new Properties();
			def status = "";
			def publishURL=null;
			def reports = [:]
			def isVerdictSet = false;
			def isURLSet = false;
			def verdictMatcher = null;
			def serverURLMatcher = null;
			def reportMatcher = null;
			def reportPattern = Pattern.compile("--REPORT=(.*)[|]--URL=(.*)");
			def serverURLPattern = Pattern.compile("--PUBLISH_URL=(.*)");
			def verdictPattern = Pattern.compile("--VERDICT=(INCONCLUSIVE|ERROR|PASS|FAIL).*");
			
			//Retrieving Verdict, published server URL, Reports name and corresponding reports URL from the CommandLineLog.txt file
			
			def tempfileloc = System.getProperty("java.io.tmpdir");
			if (!tempfileloc.endsWith(File.separator))
				tempfileloc += File.separator;
			tempfileloc += "CommandLineLog.txt";
			
			def tempFile = new File(tempfileloc);
			
			if(tempFile!=null && tempFile.exists()) {
				BufferedReader commandlinelogreader = new BufferedReader(new FileReader(tempFile));
				def line = commandlinelogreader.readLine();
				while (line != null) {
					verdictMatcher = verdictPattern.matcher(line);
					serverURLMatcher = serverURLPattern.matcher(line);

					if(!isVerdictSet && verdictMatcher.find()) {
						status = verdictMatcher.group(1);
						println "Test Result = "+status;
						outputProps.setProperty("TestResult", status.trim());
						if(status.equals("FAIL") || status.equals("ERROR")) {
							outputProps.setProperty("Status", "Failure");
						}
						else {
							outputProps.setProperty("Status","Success");
						}
						isVerdictSet = true;
					}

					else if(!isURLSet && serverURLMatcher.find()) {
						publishURL = serverURLMatcher.group(1);
						isURLSet = true;
					}

					else {
						reportMatcher = reportPattern.matcher(line);
						if(reportMatcher.find()) {
							reports.put(reportMatcher.group(1), reportMatcher.group(2));
						}
						reportMatcher = null;
					}
					verdictMatcher = null;
					serverURLMatcher = null;
					line = commandlinelogreader.readLine();
				}
			}

			if(!isVerdictSet) {
				outputProps.setProperty("TestResult", "FAIL");
				outputProps.setProperty("Status", "Failure");
			}
			
			if(!reports.isEmpty() && publishURL!=null) {
				println();
				println("Published Reports Information:");
				for (entry in reports) {
					try {
						println (entry.key + " : " + new URI(publishURL).resolve(entry.value));
					}catch (URISyntaxException e) {
						println "Error:"+e.message;
					}
				}
			}

			//persist outputProps
			def outputPropsFile = new File(mainOutProps);
			def outputPropsStream = null;
			try {
				outputPropsStream = new FileOutputStream(outputPropsFile);
				outputProps.store(outputPropsStream, null);
			}
			finally {
				outputPropsStream.close();
			}
		}
		catch (Exception e) {
			println "Error:"+e.message;
			System.exit(1);
		}
	}
	
	
	
	def getTestWorkbenchDir()
	{
		return getDirThroughEnvVar(ENV_VAR_SDP_DIR);
	}
	
	def getDirThroughEnvVar(String envVar) throws RuntimeException
	{
		def value = System.getenv(envVar);
		def isValid = isValidEnvVar(value);
		if(isValid)
		{
			isValid = new File(value).isDirectory();
		}
		
		if(!isValid)
		{
			throw new RuntimeException("Could not find a valid TEST_WORKBENCH_HOME environment variable pointing to installation directory");
		}
		return value;
	}
	
	def isValidEnvVar(def envVarValue)
	{
		
		def valid = true;
		if(envVarValue == null || envVarValue.isEmpty())
			valid = false;
		
		else
		{
			envVarValue = envVarValue.toLowerCase();		
			if(envVarValue.contains("*") || envVarValue.contains("?") || 
					envVarValue.startsWith("del ") || envVarValue.startsWith("rm "))
				valid = false;
		}
		
		return valid;
	}
	
	def getIMSharedLocation(def eclipsehome){
		def ibmloc = null;
		def rollupIndex = eclipsehome.lastIndexOf(File.separator);
		if(eclipsehome.length() == rollupIndex+1 ) {
			ibmloc = eclipsehome.substring(0, rollupIndex);
			rollupIndex = ibmloc.lastIndexOf("/");
		}
		ibmloc = eclipsehome.substring(0, rollupIndex);		
		imsharedloc = ibmloc + File.separator + "HCLIMShared";
		
		return imsharedloc;
	}
	
	
	def initIMData(){
		try {

			eclipsehome = getTestWorkbenchDir();
			println  "eclipsehome "+eclipsehome;
			def fEclipsehome = new File(eclipsehome);
			if (!fEclipsehome.exists()) {
				println "Product eclipse cannot be found at "+ eclipsehome;
				throw new RuntimeException("Product eclipse cannot be found at "+ eclipsehome);
			}

			if (imsharedloc != null && !imsharedloc.equalsIgnoreCase("null") && imsharedloc.toString().trim().length() > 0) {
				println  "imsharedloc : "+imsharedloc;
				def fIbmsharedloc = new File(imsharedloc);
				if(!fIbmsharedloc.exists()){
					throw new RuntimeException("Invalid IMShared Location : "+imsharedloc);
				}
			}
			else {
				imsharedloc = getIMSharedLocation(eclipsehome);
				println  "imsharedloc : "+imsharedloc;
				def fIbmsharedloc = new File(imsharedloc);
				if(imsharedloc == null || imsharedloc.toString().isEmpty() || !fIbmsharedloc.exists()){
					throw new RuntimeException("IMSharedLocation is not at default location, Please provide IMSharedloc parameter");
				}
			}
			
			plugins = imsharedloc + File.separator+"plugins";
			def fIbmshared = new File(plugins);
			if (!fIbmshared.exists()) {
				throw new RuntimeException("IBM Shared Resource Plugins Directory cannot be found at "+ plugins);
			}
			

		}catch (RuntimeException e) {
			throw new RuntimeException(e.toString());
		}catch (Exception e) {
			println "Error:"+e.message;
			System.exit(1);
		}

	}

	def getIMSharedLoc(def cmdPath){
		def imsharedLoc = "";
		try {

			// Build args
			def cmdargs = [];
			cmdargs = [cmdPath, 'listInstallationDirectories', '-long'];
			def cmdOutput = cmdHelper.executeAndReturnValue(cmdargs);
			def installresult = cmdOutput;
			def installdirs = installresult.split('\n');
			for (def x=0; x<installdirs.length; x++){
				//println "InstallDir :" + installdirs[x];
				// Path to IBMIMShared
				if(installdirs[x].contains("*")){
					def installtokens = installdirs[x].split(" : ");
					imsharedLoc = installtokens[1];
					println "IBMIMShared Loc "+imsharedLoc;
					break;
				}
			}
		}catch (Exception e) {
			println "Error:"+e.message;
			System.exit(1);
		}
		return imsharedLoc;
	}
	
	def srchPkgsForProd(def pkgresult, RTWProduct prod){
		def sdpLoc ="";
		def packages = pkgresult.split("\n");
		for (def x=0; x<packages.length; x++){
			//println "Package :" + packages[x];
			// Path to IBMIMShared
			def pkgtokens = packages[x].split(" : ");
			if(pkgtokens.length > 1){//just a sanity
				if(pkgtokens[1].contains(prod.getFeaturePackage())){// RPT Path
					println "SDP Location "+pkgtokens[0];
					sdpLoc = pkgtokens[0];
					break;
				}
			}
		}
		return sdpLoc;
	}
	
	def getSDPLocation(def cmdPath, RTWProduct prod){
		def sdpLoc = "";
		try {
			def cmdargs = [];
			cmdargs = [cmdPath, 'listInstalledPackages', '-features', '-long'];
			def cmdOutput = cmdHelper.executeAndReturnValue(cmdargs);
			def pkgresult = cmdOutput;
			
			if(pkgresult.contains(prod.getFeaturePackage()))
			{
				sdpLoc = srchPkgsForProd(pkgresult,prod);
			}
			
			if(sdpLoc == "" && prod == RTWProduct.RPT){
				// Try to execute using RST
				if(pkgresult.contains(RTWProduct.RST.getFeaturePackage()))
				{
					sdpLoc = srchPkgsForProd(pkgresult,RTWProduct.RST);
				}
			}
			
			if(sdpLoc == "" && prod == RTWProduct.RTWec){
				// Try to execute using RST
				if(pkgresult.contains(RTWProduct.MTE.getFeaturePackage()))
				{
					sdpLoc = srchPkgsForProd(pkgresult,RTWProduct.MTE);
				}
			}
		
			
		}catch (Exception e) {
			println "Error:"+e.message;
			System.exit(1);
		}
		return sdpLoc;
	}
}
