/******************************************************************************* 
* Licensed Materials - Property of IBM and/or HCL 
* (c) Copyright IBM Corporation 2000, 2013. All Rights Reserved. 
* (c) Copyright HCL Technologies Ltd. 2017. All Rights Reserved. 
* 
* Note to U.S. Government Users Restricted Rights: 
* Use, duplication or disclosure restricted by GSA ADP Schedule 
* Contract with IBM Corp. 
*******************************************************************************/

import com.urbancode.air.AirPluginTool
import com.urbancode.air.CommandHelper

final def workDir = new File('.').canonicalFile

def apTool = new AirPluginTool(args[0], args[1])
final def props = apTool.getStepProperties()

def rftProjectDir = props['projectDir'];
println "HOT-UI"+"ProjectDir : " + rftProjectDir;
def rftScriptName = props['scriptName'];
println "HOT-UI"+"ScriptName : " + rftScriptName;
def logFormat = props['logFormat'];
println "logFormat : " + logFormat;
def iterationCount = props['iterationCount'];
println "iterationCount : " + iterationCount;
def userArgs = props['userArgs'];
println "userArgs : " + userArgs;

def RFT_ECLIPSE_DIR = System.getenv("HCL_HFT_ECLIPSE_DIR");

def rftEclipseDir = new File(RFT_ECLIPSE_DIR);
if (!rftEclipseDir.exists()) {
	throw new RuntimeException("Cannot get HCL_HFT_ECLIPSE_DIR");
}

def RFT_INSTALL_DIR = System.getenv("HCL_HFT_INSTALL_DIR");

def rftInstallDir = new File(RFT_INSTALL_DIR);
if (!rftInstallDir.exists()) {
	throw new RuntimeException("Cannot get HCL_HFT_INSTALL_DIR");
}

def execFileName = apTool.isWindows ? "java.exe" : "java"
def relativeJavaPath = RFT_ECLIPSE_DIR + File.separator + "jdk" + 
										File.separator + "jre" +
										File.separator + "bin" +
										File.separator + execFileName;

def javaExecutable = new File(relativeJavaPath);
if (!javaExecutable.exists()) {
	throw new RuntimeException("Cannot get java executable!");
}

def rationalFtExecutable = new File(RFT_INSTALL_DIR, File.separator + "hcl_ft.jar");
if (!rationalFtExecutable.exists()) {
	throw new RuntimeException("Cannot get hcl_ft.jar!");
}

def ch = new CommandHelper(new File('.'))

try {
	// Execute
	ch.println("Java exec at " + javaExecutable);
	ch.println("HOT-UI exec at " + rationalFtExecutable);
	ch.println("HOT-UI project dir at " + rftProjectDir);
	ch.println("HOT-UI script at " + rftScriptName);

	// Build args
	def args = [];
	args = [javaExecutable.toString(), '-jar', rationalFtExecutable.toString(), 
		'-datastore', rftProjectDir, '-rt.log_format', logFormat, "-rt.bring_up_logviewer", 
		"false"];

	if(iterationCount != null && !iterationCount.toString().isEmpty()) 
	{
		arg = '-iterationCount';
		args << arg;
		args << iterationCount;
	}
	
    arg =  '-execmode';
    args << arg;
    arg = 'ucd';
    args << arg;  
   
	arg = '-playback';
	args << arg;
	args << rftScriptName;
	
	
	if(userArgs != null && !userArgs.toString().isEmpty())
	{
		arg = '-args';
		args << arg;
		def userArgString = userArgs;
		args << userArgString;
	}
		
	ch.runCommand("Running test..", args);

	def outputProps = new Properties();
	
	def playbackLogDir = rftProjectDir + "_logs";
	println "Playback log dir is "  + playbackLogDir;
	outputProps.setProperty("PlaybackLogDir", playbackLogDir);
	
	println "test output file path is " + playbackLogDir + "\\"+rftScriptName+ "\\testOutput.txt" ;
	def fResultFile = new File(playbackLogDir + "\\"+rftScriptName + "\\testOutput.txt");
	if(fResultFile.exists())
	{
		def exportlogreader = new BufferedReader(new FileReader(fResultFile));
		try
		{
			def sb = new StringBuilder();
			def line = exportlogreader.readLine();
	
			if(line != null)
			{
				def testResult = line.toString();
				println "Test Result = " + testResult;
				outputProps.setProperty("TestResult", testResult);
			}
			else
				outputProps.setProperty("TestResult", "Fail");
		}
		finally 
		{
			exportlogreader.close();
		}
	}
	else
	{
		outputProps.setProperty("TestResult", "Fail");
	}
	
	def outputPropsFile = new File(this.args[1]);
	def outputPropsStream = null;
	try {
		outputPropsStream = new FileOutputStream(outputPropsFile);
		outputProps.store(outputPropsStream, null);
	}
	finally {
		outputPropsStream?.close();
	}
}
catch (Exception e) {
    System.out.println("Error running test!");
    e.printStackTrace();
    System.exit(1);
}