/*
 * Decompiled with CFR 0.152.
 */
package com.ghc.ghTester.ant.vie.stubs.environment;

import com.ghc.ghTester.ant.vie.stubs.environment.EnvironmentDefinition;
import java.io.IOException;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class EnvironmentDefinitionFactory {
    private static final Logger log = Logger.getLogger(EnvironmentDefinitionFactory.class.getName());
    public static final EnvironmentDefinitionFactory INSTANCE = new EnvironmentDefinitionFactory();

    public EnvironmentDefinition createFromXml(String baseURL, String href, String xml) throws ParserConfigurationException, SAXException, IOException, URISyntaxException {
        URI baseUri = new URI(baseURL);
        return this.createFromXml(baseUri, href, xml);
    }

    public EnvironmentDefinition createFromXml(URI baseUri, String href, String xml) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = builderFactory.newDocumentBuilder();
        Document document = builder.parse(new InputSource(new StringReader(xml)));
        Element root = document.getDocumentElement();
        String name = root.getAttribute("name");
        String desc = root.getAttribute("description");
        NodeList childNodes = root.getChildNodes();
        String baseEnvName = null;
        String baseEnvHref = null;
        HashMap<String, String> tags = null;
        String lockedString = null;
        String lockHref = null;
        if (childNodes != null) {
            int i = 0;
            while (i < childNodes.getLength()) {
                Element element;
                Node node = childNodes.item(i);
                if (node.getNodeName().equalsIgnoreCase("base-environment")) {
                    if (node instanceof Element) {
                        element = (Element)node;
                        baseEnvName = element.getAttribute("name");
                        baseEnvHref = element.getAttribute("href");
                    }
                } else if (node.getNodeName().equalsIgnoreCase("tags")) {
                    if (node instanceof Element) {
                        tags = new HashMap<String, String>();
                        NodeList tagNodes = ((Element)node).getChildNodes();
                        int t = 0;
                        while (t < tagNodes.getLength()) {
                            Node tagNode = tagNodes.item(t);
                            if (tagNode.getNodeName().equalsIgnoreCase("tag") && tagNode instanceof Element) {
                                Element tagElement = (Element)tagNode;
                                String tagName = tagElement.getAttribute("name");
                                String tagValue = tagElement.getAttribute("value");
                                tags.put(tagName, tagValue);
                            }
                            ++t;
                        }
                    }
                } else if (node.getNodeName().equalsIgnoreCase("lock") && node instanceof Element) {
                    element = (Element)node;
                    lockedString = element.getAttribute("locked");
                    lockHref = element.getAttribute("href");
                    lockHref = baseUri.resolve(lockHref).toString();
                }
                ++i;
            }
        }
        if (lockedString != null && lockHref != null) {
            return new EnvironmentDefinition(href, name, baseEnvName, baseEnvHref, desc, tags, Boolean.parseBoolean(lockedString), lockHref);
        }
        log.severe("Unable to build EnvironmentDefinition from XML: " + xml);
        return null;
    }
}

