/*
 * Decompiled with CFR 0.152.
 */
package com.ghc.ghTester.ant.vie;

import com.ghc.ghTester.ant.vie.DomUtils;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class DomUtilsTest {
    @Test
    public void testElementIterableWithElementList() {
        ListBackedNodeList nodeList = new ListBackedNodeList(Arrays.asList(this.createElement("el1"), this.createElement("el2")));
        DomUtils.ElementIterable iterable = new DomUtils.ElementIterable((NodeList)nodeList);
        Iterator iterator = iterable.iterator();
        Assert.assertTrue((String)"Iterator should have first item", (boolean)iterator.hasNext());
        Assert.assertTrue((String)"Iterator should have first item when checked a second time", (boolean)iterator.hasNext());
        Assert.assertEquals((String)"Iterator's first item's name", (Object)"el1", (Object)((Element)iterator.next()).getNodeName());
        Assert.assertTrue((String)"Iterator should have second item", (boolean)iterator.hasNext());
        Assert.assertTrue((String)"Iterator should have second item when checked twice", (boolean)iterator.hasNext());
        Assert.assertEquals((String)"Iterator's second item's name", (Object)"el2", (Object)((Element)iterator.next()).getNodeName());
        Assert.assertFalse((String)"Iterator should not have third item", (boolean)iterator.hasNext());
    }

    @Test
    public void testElementIterableWithElementsAndTextNodes() {
        ListBackedNodeList nodeList = new ListBackedNodeList(Arrays.asList(this.createTextNode("t1"), this.createElement("el1"), this.createTextNode("t2"), this.createElement("el2"), this.createTextNode("t3")));
        DomUtils.ElementIterable iterable = new DomUtils.ElementIterable((NodeList)nodeList);
        Iterator iterator = iterable.iterator();
        Assert.assertTrue((String)"Iterator should have first item", (boolean)iterator.hasNext());
        Assert.assertTrue((String)"Iterator should have first item when checked a second time", (boolean)iterator.hasNext());
        Assert.assertEquals((String)"Iterator's first item's name", (Object)"el1", (Object)((Element)iterator.next()).getNodeName());
        Assert.assertTrue((String)"Iterator should have second item", (boolean)iterator.hasNext());
        Assert.assertTrue((String)"Iterator should have second item when checked twice", (boolean)iterator.hasNext());
        Assert.assertEquals((String)"Iterator's second item's name", (Object)"el2", (Object)((Element)iterator.next()).getNodeName());
        Assert.assertFalse((String)"Iterator should not have third item", (boolean)iterator.hasNext());
    }

    @Test
    public void testElementIterableWithTextNodes() {
        ListBackedNodeList nodeList = new ListBackedNodeList(Arrays.asList(this.createTextNode("t1"), this.createTextNode("t2"), this.createTextNode("t3")));
        DomUtils.ElementIterable iterable = new DomUtils.ElementIterable((NodeList)nodeList);
        Iterator iterator = iterable.iterator();
        Assert.assertFalse((String)"Iterator should not have any items", (boolean)iterator.hasNext());
    }

    private Element createElement(String name) {
        Element element = (Element)EasyMock.createNiceMock(Element.class);
        EasyMock.expect((Object)element.getNodeName()).andStubReturn((Object)name);
        EasyMock.replay((Object[])new Object[]{element});
        return element;
    }

    private Text createTextNode(String text) {
        Text textNode = (Text)EasyMock.createNiceMock(Text.class);
        EasyMock.expect((Object)textNode.getTextContent()).andStubReturn((Object)text);
        EasyMock.expect((Object)textNode.getData()).andStubReturn((Object)text);
        EasyMock.replay((Object[])new Object[]{textNode});
        return textNode;
    }

    private class ListBackedNodeList
    implements NodeList {
        private final List<Node> list;

        public ListBackedNodeList(List<Node> list) {
            this.list = list;
        }

        @Override
        public int getLength() {
            return this.list.size();
        }

        @Override
        public Node item(int arg0) {
            return this.list.get(arg0);
        }
    }
}

