import com.urbancode.air.AirPluginTool
import com.urbancode.air.plugin.automation.QCRunTest

final def apTool = new AirPluginTool(this.args[0], this.args[1])
final def workDir = new File('.').canonicalFile
def stepProps = apTool.getStepProperties()

def dir = new File(workDir, stepProps['workDirOffset'] ?: '.').canonicalFile

def serverUrl = stepProps['almServerUrl']
def username = stepProps['almUsername']
def password = stepProps['almPassword'] ? stepProps['almPassword'] : stepProps['passwordscript']

def domain = stepProps['almDomain']
def project = stepProps['almProject']
def folder = stepProps['folder']
def testSetName = stepProps['testSetName']
def skipOutput = Boolean.valueOf(stepProps['skipOutput'])
def runLocally = Boolean.valueOf(stepProps['runLocally'])
def recursiveSearch = Boolean.valueOf(stepProps['recursiveSearch'])
def remoteHost = stepProps['remotehost']

QCRunTest runTest = new QCRunTest()
runTest.serverUrl = serverUrl
runTest.username = username
runTest.password = password
runTest.domain = domain
runTest.project = project

runTest.folder = folder
runTest.testSetName = testSetName
runTest.skipOutput = skipOutput
runTest.runLocally = runLocally
runTest.remoteHost = remoteHost

runTest.workDir = dir

runTest.execute()