/*
 * Licensed Materials - Property of IBM Corp.
 * IBM UrbanCode Deploy
 * (c) Copyright IBM Corporation 2017. All Rights Reserved.
 *
 * U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
 * GSA ADP Schedule Contract with IBM Corp.
 */
import com.urbancode.air.AirPluginTool
import com.urbancode.air.plugin.automation.QCRunTest

final def apTool = new AirPluginTool(this.args[0], this.args[1])
final def workDir = new File('.').canonicalFile
def stepProps = apTool.getStepProperties()

def dir = new File(workDir, stepProps['workDirOffset'] ?: '.').canonicalFile

def serverUrl = stepProps['almServerUrl']
def username = stepProps['almUsername']
def password = stepProps['almPassword'] ? stepProps['almPassword'] : stepProps['passwordscript']

def domain = stepProps['almDomain']
def project = stepProps['almProject']
def folder = stepProps['folder']
def testSetName = stepProps['testSetName']
def skipOutput = Boolean.valueOf(stepProps['skipOutput'])
def runLocally = Boolean.valueOf(stepProps['runLocally'])
def recursiveSearch = Boolean.valueOf(stepProps['recursiveSearch'])
def remoteHost = stepProps['remotehost']
def successfulExitStatus = stepProps['successfulExitStatus'] ?: "0"

QCRunTest runTest = new QCRunTest()
runTest.serverUrl = serverUrl
runTest.username = username
runTest.password = password
runTest.domain = domain
runTest.project = project
runTest.successfulExitStatus = successfulExitStatus

runTest.folder = folder
runTest.testSetName = testSetName
runTest.skipOutput = skipOutput
runTest.runLocally = runLocally
runTest.remoteHost = remoteHost

runTest.workDir = dir

String testSummary = runTest.execute()

apTool.setOutputProperty('hp-alm.testSummary', testSummary)
apTool.setOutputProperties()

if (runTest.failedTests) {
    println("[Error] Failures have occurred during test execution.")
    System.exit(1)
}