/*
 * Licensed Materials - Property of IBM Corp.
 * IBM UrbanCode Deploy
 * (c) Copyright IBM Corporation 2015. All Rights Reserved.
 *
 * U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
 * GSA ADP Schedule Contract with IBM Corp.
 */
import com.urbancode.air.AirPluginTool
import com.urbancode.air.plugin.automation.HPQCUpdateDefects
import com.urbancode.air.plugin.hp.alm.rest.ALMRestHelper
import com.urbancode.air.plugin.hp.alm.rest.ALMRestException

def apTool = new AirPluginTool(this.args[0], this.args[1])
ALMRestHelper helper = new HPQCUpdateDefects(apTool.getStepProperties())
int exitVal = 0

try {
    helper.authenticate()
    helper.updateDefects()
}
catch (ALMRestException ex) {
    println("Error while updating defects" + ex)
    ex.printStackTrace()
    exitVal = 1
}
finally {
    helper.logout()
}

System.exit(exitVal)