/*
 * Licensed Materials - Property of IBM Corp.
 * IBM UrbanCode Deploy
 * (c) Copyright IBM Corporation 2017. All Rights Reserved.
 *
 * U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
 * GSA ADP Schedule Contract with IBM Corp.
 */
package com.urbancode.air.plugin.automation

public class QCRunTest extends AutomationBase {
    final String SUMMARY_START_DELIMITER = "HP ALM Test-Set Summary:"
    final String SUMMARY_END_DELIMITER = "End Of HP ALM Test-Set Summary"
    final String FAILURE_DELIMITER = "HP ALM Test Failures:"
    String folder
    String testSetName
    boolean skipOutput
    String skipInt
    boolean runLocally
    String runLocallyInt
    boolean recursiveSearch
    String recursiveSearchInt
    String remoteHost
    boolean failedTests

    public String execute() {
        init()

        if (skipOutput) {
            skipInt = "1"
        }
        else {
            skipInt = "0"
        }

        if(runLocally) {
            runLocallyInt = "1"
        }
        else {
            runLocallyInt = "0"
        }

        if (recursiveSearch) {
            recursiveSearchInt = "1"
        }
        else {
            recursiveSearchInt= "0"
        }

        def command = generateCommand()
        String testSetOutput = runCommandWithOutput("Running Test Set", command)
        println(testSetOutput) // print process output to stdout

        failedTests = testSetOutput.contains(FAILURE_DELIMITER)

        // parse test set summary from output
        String testSummary
        if (testSetOutput.contains(SUMMARY_START_DELIMITER) && testSetOutput.contains(SUMMARY_END_DELIMITER)) {
            int beginIndex = testSetOutput.indexOf(SUMMARY_START_DELIMITER)
            int endIndex = testSetOutput.indexOf(SUMMARY_END_DELIMITER)
            testSummary = testSetOutput.substring(beginIndex + SUMMARY_START_DELIMITER.length(), endIndex)
        }
        else {
            println("[Error] Failed to execute test set.")
            throw new RuntimeException("Failed to execute test set.")
        }

        return testSummary
    }

    private def generateCommand() {
        String allInFolder // int value to determine if all test-sets will be run in provided folder

        def command = [cscriptExe]
        command << PLUGIN_HOME + "\\qc_run_test_set.vbs"
        command << serverUrl
        command << username
        command << password
        command << domain
        command << project
        command << skipInt
        command << runLocallyInt
        command << folder

        if (testSetName) {
            allInFolder = 0
        }
        else {
            allInFolder = 1
        }

        command << allInFolder
        command << recursiveSearchInt
        command << successfulExitStatus
        command << testSetName // blank values will be ignored by script

        if (remoteHost) {
            command << remoteHost
        }

        return command
    }
}