'Licensed Materials - Property of IBM Corp.
'IBM UrbanCode Build
'(c) Copyright IBM Corporation 2017. All Rights Reserved.
'U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
'GSA ADP Schedule Contract with IBM Corp.

'======================== Functions ========================
Dim tdConnection

Function disconnect()
    If IsObject(tdConnection) Then
        If tdConnection.Connected Then
            tdConnection.Disconnect()
            WScript.StdOut.WriteLine "Connection disconnected"
        End If
        If tdConnection.LoggedIn Then
            tdConnection.Logout()
            WScript.StdOut.WriteLine "Connection logged out"
        End If
        tdConnection.ReleaseConnection()
        WScript.StdOut.WriteLine "Connection released"
    End If
End Function

Function createConnection(serverUrl, username, password, domain, project)
    Dim connectionCreated
    connectionCreated = False

    Set tdConnection = CreateObject("TDApiOle80.TDConnection")

    If tdConnection Is Nothing Then
      WScript.StdOut.WriteLine = "Failed to create TDApiOle80.TDConnection Object"
    Else
      tdConnection.InitConnectionEx(serverUrl)
      If tdConnection.Connected = False Then
        WScript.StdOut.WriteLine "Connection failed to Quality Center server " & serverUrl
      Else
        WScript.StdOut.WriteLine "Connection created to Quality Center server " & serverUrl
        tdConnection.Login username, password
        If tdConnection.LoggedIn = False Then
          WScript.StdOut.WriteLine "Connection failed to log in as user " & username
        Else
          WScript.StdOut.WriteLine "Connection logged in as user " & username
          tdConnection.Connect domain, project
          If tdConnection.ProjectConnected = False Then
            WScript.StdOut.WriteLine "Connection failed to open project " & domain & "\" & project
          Else
            WScript.StdOut.WriteLine "Connection opened project " & domain & "\" & project
            connectionCreated = True
          End If
        End If
      End If
    End If

    If Not connectionCreated Then
        disconnect()
    End If

    createConnection = connectionCreated
End Function

Function runTestSetFolders(ByRef testSetFolder, skipOutput, remoteHost)
    Dim folderList
    Set folderList = CreateObject("System.Collections.ArrayList")
    folderList.add testSetFolder

    ' add all subfolders to the list of folder objects
    Dim childNodes
    Set childNodes = testSetFolder.FindChildren("")
    folderList.addRange(childNodes)

    For Each folder in FolderList
        runTestSets testSetFolder, "", skipOutput, remoteHost
        runTestSetFolders folder, skipOutput, remoteHost
    Next
End Function

Function runTestSets(ByRef testSetFolder, testSetName, skipOutput, remoteHost)
    Dim testSetList

    If IsNull(testSetName) Or Len(testSetName) = 0 Then
        Set testSetList = testSetFolder.FindTestSets("")
        If testSetList.Count = 0 Then
            WScript.StdOut.WriteLine "No Test Sets found in folder '" & testSetPath & "'"
        End If
    Else
        Set testSetList = testSetFolder.FindTestSets(testSetName)
        If testSetList.Count = 0 Then
            WScript.StdOut.WriteLine "Test Set named '" & testSetName & "' not found."
        ElseIf testSetList.Count > 1 Then
            WScript.StdOut.WriteLine "Multiple Test Sets named '" & testSetName & "' were found."
        End If
    End If

    Dim testSet
    For Each testSet In testSetList
        WScript.StdOut.WriteLine "Found test set " & testSet.ID & " for " & testSetPath & "\" & testSet.Name

        Dim scheduler
        Set scheduler = testSet.StartExecution("")
        If IsNull(scheduler) Then
            WScript.StdOut.WriteLine "Scheduler could not be created!"
            WScript.Quit 1
        End If

        Set tsTestFactory = testSet.TSTestFactory
        Set tdFilter = tsTestFactory.Filter
        tdFilter.Filter("TC_CYCLE_ID") = testSet.ID
        Set tList = tsTestFactory.NewList(tdFilter.Text)

        If runLocally = True Then
            scheduler.RunAllLocally = True
        ElseIf Len(remoteHost) = Null Or Len(remoteHost) = 0 Then
            scheduler.RunAllLocally = False
        End If

        i = 1
        If runLocally = True Then
            WScript.StdOut.WriteLine "Running test set locally"
        Else
            For Each test in tList
                If Len(remoteHost) = Null Or Len(remoteHost) = 0 Then
                    If Len(test.HostName) = Null Or Len(test.HostName) = 0 Then
                        WScript.StdOut.WriteLine "[Error] There is not HostName set for the test: " & test.Name
                        WScript.StdOut.WriteLine "[Solution] You must either provide a 'Planned Host' for the test in the HP ALM Test Lab, provide a Remote Host to run on, or check the Run Locally box."
                        WScript.Quit 1
                    End If
                    WScript.StdOut.WriteLine "Setting test " & test.Name & " to run on host " & test.HostName
                    scheduler.RunOnHost(test.ID) = test.HostName
                Else
                    WScript.StdOut.WriteLine "Setting test " & test.Name & " to run remotely on " & remoteHost
                    scheduler.RunOnHost(test.ID) = remoteHost
                End If
            Next
        End If

        WScript.StdOut.WriteLine "Running test set " & testSet.ID & " - " & testSetPath & "\" & testSetName
        scheduler.run

        If skipOutput = False Then
            Dim executionStatus
            Set executionStatus = scheduler.ExecutionStatus

            WScript.StdOut.WriteLine ""
            WScript.StdOut.WriteLine "Test Activity:"

            Dim statusDictionary
            Set statusDictionary = CreateObject("Scripting.Dictionary")

            Dim executionStatusItem, executingTest
            Do Until executionStatus.Finished
                WScript.Sleep( 5000 )
                executionStatus.RefreshExecStatusInfo "all", true
                Set eventList = executionStatus.EventsList()
                For i = 1 To executionStatus.Count
                    Set executionStatusItem = executionStatus.Item(i)
                    Set executingTest = testSet.TSTestFactory.Item(executionStatusItem.TSTestId)
                    status = executionStatusItem.TSTestId & " - " & executingTest.Name & " - " & _
                        executionStatusItem.Status & " - " & executionStatusItem.Message
                    lastStatus = statusDictionary.Item(executionStatusItem.TSTestId)
                    If Not status = lastStatus Then
                        statusDictionary.Remove executionStatusItem.TSTestId
                        statusDictionary.Add executionStatusItem.TSTestId, status
                        WScript.StdOut.WriteLine "   " & status
                    End If
                Next
            Loop

            WScript.StdOut.WriteLine ""
            WScript.StdOut.WriteLine "HP ALM Test-Set Summary:"
            WScript.StdOut.WriteLine " Test Set/Folder Path: " & testSet.ID & " - " & testSetPath & "\" & testSetName
            Dim failures()
            Redim failures(executionStatus.Count)
            Dim failCount
            failCount = 0

            For i = 1 To executionStatus.Count
                Set executionStatusItem = executionStatus.Item(i)
                Set executingTest = testSet.TSTestFactory.Item(executionStatusItem.TSTestId)
                WScript.StdOut.WriteLine "   " & executionStatusItem.TSTestId & " - " & executingTest.Name & " - " & _
                    executionStatusItem.Status & " - " & executionStatusItem.Message
                If executionStatusItem.Status = "FinishedFailed" Or executionStatusItem.Status = "Error" Then
                    failures(failCount) = executionStatusItem.TSTestId & " - " & executingTest.Name
                    failCount = failCount + 1
                End If
            Next

            WScript.StdOut.WriteLine "End Of HP ALM Test-Set Summary"
            WScript.StdOut.WriteLine ""

            If failCount > 0 Then
                WScript.StdOut.WriteLine "HP ALM Test Failures:"

                For i = 0 To failCount
                    WScript.StdOut.WriteLine "   " & failures(i)
                Next

            End If
        End If
    Next
End Function

'======================== Main Script ========================
Dim args
Set args = WScript.Arguments

serverUrl = args.Item(0)
username = args.Item(1)
password = args.Item(2)
domain = args.Item(3)
project = args.Item(4)
skipOutput = CBool(args.Item(5))
runLocally = CBool(args.Item(6))
testSetPath = args.Item(7)
allInFolder = CBool(args.Item(8))
recursiveSearch = CBool(args.Item(9))
successStatus = CInt(args.Item(10))
testSetName = ""
remoteHost = ""

If allInFolder = False Then
    testSetName = args.Item(11)
    If args.Count > 12 Then
        WScript.StdOut.WriteLine "I've got a remote host"
        remoteHost = args.Item(12)
    End If
Else
    If args.Count > 11 Then
        WScript.StdOut.WriteLine "I've got a remote host"
        remoteHost = args.Item(11)
    End If
End If

' prepend Root\ to the testSetPath if it is not already there
If InStr(testSetPath, "Root\") = 0 Then
    testSetPath = "Root\" & testSetPath
End If

connectionCreated = createConnection(serverUrl, username, password, domain, project)
If Not connectionCreated Then
    WScript.Quit 1
End If

WScript.StdOut.WriteLine "Attempting to access test set with path " & testSetPath

Dim testSetTreeManager
Set testSetTreeManager = tdConnection.TestSetTreeManager

Dim testSetFolder
Set testSetFolder = testSetTreeManager.NodeByPath(testSetPath)

If recursiveSearch = True Then
    runTestSetFolders testSetFolder, skipOutput, remoteHost
Else
    runTestSets testSetFolder, testSetName, skipOutput, remoteHost
End If
disconnect()
WScript.Quit(successStatus)