import com.urbancode.air.*
import com.urbancode.air.plugin.automation.*

final def apTool = new AirPluginTool(this.args[0], this.args[1])
final def workDir = new File('.').canonicalFile
def stepProps = apTool.getStepProperties()

def dir = new File(workDir, stepProps['workDirOffset'] ?: '.').canonicalFile

def serverUrl       = stepProps['serverUrl']
def username        = stepProps['username']
def password        = stepProps['password'] ? stepProps['password'] : stepProps['passwordscript']

def domain          = stepProps['qcdomain']
def project         = stepProps['qcproject']
def projectKey      = stepProps['projectkey']
def issuePropsStr   = stepProps['props']
def bugPattern      = stepProps['bugpattern']
def failMode        = stepProps['failmode'] ? "fast" : stepProps['failmode']
def comment         = stepProps['comment']

def assignee        = stepProps['assignee']
def summary         = stepProps['summary']
def priority        = stepProps['priority']
def status          = stepProps['status']
def severity        = stepProps['severity']
def qcProjectKey    = stepProps['qcprojectkey']
def detectedBy      = stepProps['detectedby']

// parse the additional fields into a Properties object
def additionalFields = new Properties()
if (issuePropsStr) {
    try {
        additionalFields.load(new ByteArrayInputStream(issuePropsStr.getBytes()))
    }
    catch (Exception e) {
        throw new Exception("Additional fields formatted incorrectly: " + e.getMessage())
    }
}

QCUpdate update = new QCUpdate()
update.serverUrl = serverUrl
update.username = username
update.password = password
update.domain = domain
update.project = project

update.projectKey = projectKey
update.bugPattern = bugPattern
update.failMode = failMode
update.comment = comment

update.assignee = assignee
update.summary = summary
update.priority = priority
update.status = status
update.severity = severity
update.qcProjectKey = qcProjectKey
update.detectedBy = detectedBy
update.additionalFields = additionalFields

update.workDir = dir

update.execute()