//------------------------------------------------------------------------------
// Utility variables
//------------------------------------------------------------------------------
final def isWindows = (System.getProperty('os.name') =~ /(?i)windows/).find()
final def FS = File.separator

final def PLUGIN_HOME = System.getenv()['PLUGIN_HOME']
final def JACOB_HOME = PLUGIN_HOME + FS + "lib" + FS + "native"
final def GROOVY_HOME = System.getenv()['GROOVY_HOME']
final def groovy = GROOVY_HOME + FS + "bin" + FS + "groovy.bat"

final def groovyargs = args;
final def out = System.out

//------------------------------------------------------------------------------
// Build the command
//------------------------------------------------------------------------------

def command = []
command.add(groovy)
command.add(args[0])
command.add('"' + args[1] + '"')
command.add("\"-Djava.library.path=$JACOB_HOME\"")
command.add("-Dcom.jacob.debug=false")
command.add('"' + args[2] + '"')

//this is neccessary for the new plugin runtime which adds the input and output props as the last two arguments
for (int i = 3; i < args.length; i ++ ) {
     command.add('"' + args[i] + '"');
}

println command.join(' ')

//------------------------------------------------------------------------------
// Execute the sub-process with the Jacob DLL in the classpath
//------------------------------------------------------------------------------

def processEnv = System.getenv().collect() { entry ->
    entry.key + "=" + entry.value
}
processEnv.add("JAVA_OPTS=-Djava.library.path=\"$JACOB_HOME\"")

//println processEnv.join("\n")

def process = (command as String[]).execute(processEnv, new File("."))
process.consumeProcessOutput(out, out);

process.waitFor()

if (process.exitValue()) {
    System.exit(process.exitValue())
}
