
import com.urbancode.air.*
import com.urbancode.air.plugin.automation.*

final def apTool = new AirPluginTool(this.args[0], this.args[1])
final def workDir = new File('.').canonicalFile
def stepProps = apTool.getStepProperties()

def dir = new File(workDir, stepProps['workDirOffset'] ?: '.').canonicalFile

def serverUrl = stepProps['serverUrl']
def username = stepProps['username']
def password = stepProps['password'] ? stepProps['password'] : stepProps['passwordscript']

def domain = stepProps['qcdomain']
def project = stepProps['qcproject']
def issueIds = stepProps['issueIds']
def outFile = stepProps['outFile']

QCPublishBugReport report = new QCPublishBugReport()
report.serverUrl = serverUrl
report.username = username
report.password = password
report.domain = domain
report.project = project
report.issueIds = issueIds
report.outputFileName = outFile

report.workDir = dir

report.execute()