'======================== Functions ========================
Dim tdConnection

Function disconnect()
    If IsObject(tdConnection) Then
        If tdConnection.Connected Then
            tdConnection.Disconnect()
            WScript.StdOut.WriteLine "Connection disconnected"
        End If
        If tdConnection.LoggedIn Then
            tdConnection.Logout()
            WScript.StdOut.WriteLine "Connection logged out"
        End If
        tdConnection.ReleaseConnection()
        WScript.StdOut.WriteLine "Connection released"
    End If
End Function

Function createConnection(serverUrl, username, password, domain, project)
    Dim connectionCreated
    connectionCreated = False
    
    Set tdConnection = CreateObject("TDApiOle80.TDConnection")

    If tdConnection Is Nothing Then
      WScript.StdOut.WriteLine = "Failed to create TDApiOle80.TDConnection Object"
    Else
      tdConnection.InitConnectionEx(serverUrl)
      If tdConnection.Connected = False Then
        WScript.StdOut.WriteLine "Connection failed to Quality Center server " & serverUrl
      Else
        WScript.StdOut.WriteLine "Connection created to Quality Center server " & serverUrl
        tdConnection.Login username, password
        If tdConnection.LoggedIn = False Then
          WScript.StdOut.WriteLine "Connection failed to log in as user " & username
        Else
          WScript.StdOut.WriteLine "Connection logged in as user " & username
          tdConnection.Connect domain, project
          If tdConnection.ProjectConnected = False Then
            WScript.StdOut.WriteLine "Connection failed to open project " & domain & "\" & project
          Else
            WScript.StdOut.WriteLine "Connection opened project " & domain & "\" & project
            connectionCreated = True
          End If
        End If
      End If
    End If
    
    If Not connectionCreated Then
        disconnect()
    End If
    
    createConnection = connectionCreated
End Function
 
'======================== Main Script ========================
Dim args
Set args = WScript.Arguments
serverUrl = args.Item(0)
username = args.Item(1)
password = args.Item(2)
domain = args.Item(3)
project = args.Item(4)
criteria = Split(Replace(args.Item(5), "__QUOTE", """"),"|")
fields = Split(args.Item(6),",")

connectionCreated = createConnection(serverUrl, username, password, domain, project)
If Not connectionCreated Then
    WScript.Quit 1
End If

Dim bugFactory
Set bugFactory = tdConnection.BugFactory
Dim bugFilter
Set bugFilter = bugFactory.Filter
Dim bugFields
Set bugFields = bugFactory.Fields

Dim returnNames
Set returnNames = CreateObject("Scripting.Dictionary")

For Each field in bugFields
    name = field.name
    label = field.Property.UserLabel
    
    For Each criterion in criteria
        splitCriterion = Split(criterion,",")
        If StrComp(LCase(splitCriterion(0)),LCase(label))=0 Then bugFilter.Filter(name) = splitCriterion(1)
    Next
    
    For Each returnField in fields
        If StrComp(LCase(returnField), LCase(label))=0 Then returnNames.Add returnField, name
    Next
Next

Dim bugList
Set bugList = bugFilter.newList()

WScript.StdOut.WriteLine bugList.Count & " defects found!"
For Each bug in bugList
count = 0
    For Each returnLabel in fields
        WScript.StdOut.Write returnLabel & ": " & bug.Field(returnNames(returnLabel))
        If count < UBound(fields) Then WScript.StdOut.Write ", "
        count = count + 1
    Next
    WScript.StdOut.WriteBlankLines(1)
Next

disconnect()
WScript.Quit(1337)
