package com.urbancode.air.plugin.automation

public class QCCheckStatus extends AutomationBase {
    
    String issueIds
    String failMode
    String expectedState
    
    private def reqNumBugs
    private def idToCheck
    private def foundBugIds
    private def exitCode = 0
    
    public void execute() {
        init()
        
        idToCheck = issueIds.split(",")

        if (idToCheck && idToCheck.size()) {
            println "Defect Ids to check status on: " + issueIds
            findBugs()
            checkStatus()
        }
        else {
            println "No defects found in source changes. Nothing to do."
        }
        
        if (exitCode != 0) {
            System.exit(1)
        }
    }

    private void findBugs() {
        reqNumBugs = idToCheck.size()
        def bugIds = issueIds
        
        def outputFileName = ".numberOfBugsFound.txt"
        def findBugsCommand = [cscriptExe]
        findBugsCommand << PLUGIN_HOME + "\\qc_find_bugs.vbs"
        findBugsCommand << serverUrl
        findBugsCommand << username
        findBugsCommand << password
        findBugsCommand << domain
        findBugsCommand << project
        findBugsCommand << bugIds
        findBugsCommand << outputFileName

        cmdHelper.runCommand("Finding bugs to add comments to", findBugsCommand)
        
        verifyBugsFound(outputFileName)
    }
    
    private void verifyBugsFound(String outputFileName) {
        def outputFile = new File(outputFileName)
        foundBugIds = outputFile.text.split(",")
        def actNumBugs = foundBugIds.length
        outputFile.delete()
        
        println "Found $actNumBugs of $reqNumBugs defects in Quality Center."
        
        if (reqNumBugs != actNumBugs) {
            if (failMode == "slow") {
                println "Fail mode is 'Fail' and not all requested defects were found in Quality Center. Scheduling failure after the found defects have been updated."
                exitCode = 1
            }
            else if (failMode == "warn") {
                println "Fail mode is 'Warn' and not all requested defects were found in Quality Center. Only logging a warning."
            }
            else { // default is fast
                println "Fail mode is 'Fail-fast' and not all requested defects were found in Quality Center. Failing now."
                throw new Exception("Not all requested defects were found in Quality Center and fail mode is 'Fail-fast'")
            }
        }
    }
    
    private void checkStatus() {
        for (foundBugId in foundBugIds) {
            
            def statusOutputFile = ".bugStatus.txt"
            def checkStatusCommand = [cscriptExe]
            checkStatusCommand << PLUGIN_HOME + "\\qc_check_status.vbs"
            checkStatusCommand << serverUrl
            checkStatusCommand << username
            checkStatusCommand << password
            checkStatusCommand << domain
            checkStatusCommand << project
            checkStatusCommand << foundBugId
            checkStatusCommand << statusOutputFile
            
            
            cmdHelper.runCommand("Checking status for $foundBugId", checkStatusCommand)
            
            verifyBugStatus(statusOutputFile, foundBugId)
        }
        
        System.exit(exitCode)
    }
    
    private void verifyBugStatus(String statusOutputFile, String foundBugId) {
        def outputFile = new File(statusOutputFile)
        def foundStatus = outputFile.text
        outputFile.delete()
        
        println "The status found for defect " + foundBugId + " is " + foundStatus
        
        if (!expectedState.equalsIgnoreCase(foundStatus)) {
            if (failMode == "slow") {
                println "Fail mode is 'Fail' and the status of " +foundBugId+" was not "+expectedState+". Scheduling failure after the found defects have been updated."
                exitCode = 1
            }
            else if (failMode == "warn") {
                println "Fail mode is 'Warn' and the status of " +foundBugId+" was not "+expectedState+". Only logging a warning."
            }
            else { // default is fast
                println "Fail mode is 'Fail-fast' and the status of " +foundBugId+" was not "+expectedState+". Failing now."
                throw new Exception("The status of " +foundBugId+" was not "+expectedState+". and fail mode is 'Fail-fast'")
            }
        }
    }
}