import com.urbancode.air.*
import com.urbancode.air.plugin.automation.*

final def apTool = new AirPluginTool(this.args[0], this.args[1])
final def workDir = new File('.').canonicalFile
def stepProps = apTool.getStepProperties()

def dir = new File(workDir, stepProps['workDirOffset'] ?: '.').canonicalFile

def serverUrl = stepProps['serverUrl']
def username = stepProps['username']
def password = stepProps['password'] ? stepProps['password'] : stepProps['passwordscript']

def domain          = stepProps['qcdomain']
def project         = stepProps['qcproject']
def assignee        = stepProps['assignee']
def summary         = stepProps['summary']
def priority        = stepProps['priority']
def status          = stepProps['status']
def severity        = stepProps['severity']
def qcProjectKey    = stepProps['qcprojectkey']
def detectedBy      = stepProps['detectedby']
def detectedOn      = stepProps['detectedOn']
def detectedIn      = stepProps['detectedIn']
def reproducible    = stepProps['reproducible']
def subject         = stepProps['subject']

def issuePropsStr = stepProps['props']

QCCreate create = new QCCreate()
create.serverUrl = serverUrl
create.username = username
create.password = password
create.domain = domain
create.project = project

create.assignee = assignee
create.summary = summary
create.priority = priority
create.status = status
create.severity = severity
create.qcProjectKey = qcProjectKey
create.detectedBy = detectedBy
create.detectedOn = detectedOn
create.detectedIn = detectedIn
create.reproducible = reproducible
create.subject = subject

create.issuePropsStr = issuePropsStr

create.workDir = dir

create.execute()