import com.urbancode.air.*
import com.urbancode.air.plugin.automation.*

final def apTool = new AirPluginTool(this.args[0], this.args[1])
final def workDir = new File('.').canonicalFile
def stepProps = apTool.getStepProperties()

def dir = new File(workDir, stepProps['workDirOffset'] ?: '.').canonicalFile

def serverUrl = stepProps['serverUrl']
def username = stepProps['username']
def password = stepProps['password'] ? stepProps['password'] : stepProps['passwordscript']

def domain = stepProps['qcdomain']
def project = stepProps['qcproject']
def folder = stepProps['folder']
def testSetName = stepProps['testSetName']
def skipOutput = Boolean.valueOf(stepProps['skipOutput'])
def runLocally = Boolean.valueOf(stepProps['runLocally'])
def remoteHost = stepProps['remotehost']

QCRunTest runTest = new QCRunTest()
runTest.serverUrl = serverUrl
runTest.username = username
runTest.password = password
runTest.domain = domain
runTest.project = project

runTest.folder = folder
runTest.testSetName = testSetName
runTest.skipOutput = skipOutput
runTest.remoteHost = remoteHost
runTest.runLocally = runLocally

runTest.workDir = dir

runTest.execute()