/******************************************************************************* 
* Licensed Materials - Property of IBM and/or HCL 
* (c) Copyright IBM Corporation 2000, 2013. All Rights Reserved. 
* (c) Copyright HCL Technologies Ltd. 2017. All Rights Reserved. 
* 
* Note to U.S. Government Users Restricted Rights: 
* Use, duplication or disclosure restricted by GSA ADP Schedule 
* Contract with IBM Corp. 
*******************************************************************************/

import com.urbancode.air.AirPluginTool
import com.urbancode.air.CommandHelper
import java.util.regex.Matcher
import java.util.regex.Pattern

UI_SCALE_FLAG = "-Dsun.java2d.uiScale.enabled=false"
ASSISTIVE_TECHNOLOGY_FLAG = "-Djavax.accessibility.assistive_technologies=com.rational.test.ft.bootstrap.Bootstrap"
ECLIPSE_ENABLER_PLUGIN = "com.rational.test.ft.enabler.wsw"
BOOTSTRAP_JAR = "rational_ft_bootstrap.jar"

final def workDir = new File('.').canonicalFile

def apTool = new AirPluginTool(args[0], args[1])
final def props = apTool.getStepProperties()

def rftProjectDir = props['projectDir'];
println "DTUI-FunctionalTest"+"ProjectDir : " + rftProjectDir;
def rftScriptName = props['scriptName'];
println "DTUI-FunctionalTest"+"ScriptName : " + rftScriptName;
def logFormat = props['logFormat'];
println "logFormat : " + logFormat;
def iterationCount = props['iterationCount'];
println "iterationCount : " + iterationCount;
def userArgs = props['userArgs'];
println "userArgs : " + userArgs;
def disconnectMode = props['disconnectMode'];
println "disconnectMode : " + disconnectMode;

RFT_ECLIPSE_DIR = System.getenv("IBM_RATIONAL_RFT_ECLIPSE_DIR");

def rftEclipseDir = new File(RFT_ECLIPSE_DIR);
if (!rftEclipseDir.exists()) {
	throw new RuntimeException("Cannot get IBM_RATIONAL_RFT_ECLIPSE_DIR");
}

RFT_INSTALL_DIR = System.getenv("IBM_RATIONAL_RFT_INSTALL_DIR");

def rftInstallDir = new File(RFT_INSTALL_DIR);
if (!rftInstallDir.exists()) {
	throw new RuntimeException("Cannot get IBM_RATIONAL_RFT_INSTALL_DIR");
}

def execFileName = apTool.isWindows ? "java.exe" : "java"
def relativeJavaPath = RFT_ECLIPSE_DIR + File.separator + "jdk" + 
										File.separator + "bin" +
										File.separator + execFileName;

def javaExecutable = new File(relativeJavaPath);
if (!javaExecutable.exists()) {
	throw new RuntimeException("Cannot get java executable!");
}

def rationalFtExecutable = new File(RFT_INSTALL_DIR, File.separator + "rational_ft.jar");
if (!rationalFtExecutable.exists()) {
	throw new RuntimeException("Cannot get rational_ft.jar!");
}

def ch = new CommandHelper(new File('.'))

try {
	// Execute
	ch.println("Java exec at " + javaExecutable);
	ch.println("DTUI-FunctionalTest exec at " + rationalFtExecutable);
	ch.println("DTUI-FunctionalTest project dir at " + rftProjectDir);
	ch.println("DTUI-FunctionalTest script at " + rftScriptName);

	// Build args
	def args = [];
	args = [javaExecutable.toString()];
	
	args << UI_SCALE_FLAG;
	args << ASSISTIVE_TECHNOLOGY_FLAG;
	arg = '-classpath';
	args << arg;
	
	def bootStrapPath = verifyAndGetBootStrapEnablerPath();
	if (bootStrapPath != null) {
		arg = bootStrapPath + File.pathSeparator + rationalFtExecutable.toString()
		args << arg;
	} else {
		throw new RuntimeException("Bootstrap file path does not exist.");
	}
	arg = 'com.rational.test.ft.rational_ft';
	args << arg;

	arg = '-datastore';
	args << arg;
	args << rftProjectDir;
	
	arg = '-rt.log_format';
	args << arg;
	args << logFormat;
	
	arg = '-rt.bring_up_logviewer';
	args << arg;
	arg = 'false';
	args << arg;
	
	if(iterationCount != null && !iterationCount.toString().isEmpty()) 
	{
		arg = '-iterationCount';
		args << arg;
		args << iterationCount;
	}
	
	arg = '-playback';
	args << arg;
	args << rftScriptName;
	
	
	if(userArgs != null && !userArgs.toString().isEmpty())
	{
		arg = '-args';
		args << arg;
		def userArgString = userArgs;
		args << userArgString;
	}

	if(disconnectMode != null && disconnectMode.toString() == "true")
	{
		arg = '-bg';
		args << arg;
	}
		
	ch.runCommand("Running test..", args);

	def outputProps = new Properties();
	
	def playbackLogDir = rftProjectDir + "_logs";
	println "Playback log dir is "  + playbackLogDir;
	outputProps.setProperty("PlaybackLogDir", playbackLogDir);
	
	println "Test result information file path is " + getResultFilePath();
	
	//Retrieving test result information from the CommandLineLog.txt
	def fResultFile = new File(getResultFilePath());
	def status = null;
	def publishedResult = null;
	if(fResultFile.exists())
	{
		def verdictPattern = Pattern.compile("--VERDICT=(.*)");
		def publishedResultPattern = Pattern.compile("--REMOTE_RESULT_UI=(.*)");
		def verdictMatcher = null;
		def publishedResultMatcher = null;
		def isVerdictSet = false;
		def isPublishedResultSet = false;
		def exportlogreader = new BufferedReader(new FileReader(fResultFile));
		try
		{
			def sb = new StringBuilder();
			def line;
	
			while((!isVerdictSet || !isPublishedResultSet) && (line=exportlogreader.readLine())!=null)
			{
				verdictMatcher = verdictPattern.matcher(line);
				publishedResultMatcher = publishedResultPattern.matcher(line);
				if(verdictMatcher.find()) {
					def testResult = verdictMatcher.group(1);
					println("Test Result = " + testResult);
					outputProps.setProperty("TestResult", testResult);
					if(testResult.equals("FAIL") || testResult.equals("ERROR")) {
						outputProps.setProperty("Status", "Failure");
					}
					else {
						outputProps.setProperty("Status","Success");
					}
					isVerdictSet = true;
				}
				else if(publishedResultMatcher.find()) {
					publishedResult = publishedResultMatcher.group(1);
					println("Published Result : " + publishedResult);
					isPublishedResultSet = true;
				}
			}
			if(!isVerdictSet) {
				status = "Fail"
				println("Test Result is "+status);
				outputProps.setProperty("TestResult", status);
				outputProps.setProperty("Status", "Failure");
			}
		}
		finally 
		{
			exportlogreader.close();
		}
	}
	else
	{
		println("Result file does not exist");
		status = "Fail";
		outputProps.setProperty("TestResult", status);
		outputProps.setProperty("Status", "Failure");
	}
	
	def outputPropsFile = new File(this.args[1]);
	def outputPropsStream = null;
	try {
		outputPropsStream = new FileOutputStream(outputPropsFile);
		outputProps.store(outputPropsStream, null);
	}
	finally {
		outputPropsStream?.close();
	}
}
catch (Exception e) {
    System.out.println("Error running test!");
    e.printStackTrace();
    System.exit(1);
}

def getResultFilePath() {
	def tempfileloc = System.getProperty("java.io.tmpdir");
	if (!tempfileloc.endsWith(File.separator))
		tempfileloc += File.separator;
	tempfileloc += "CommandLineLog.txt";
	return tempfileloc;
}

def verifyAndGetBootStrapEnablerPath() {
	def bootStrapPath = getBootStrapEnablerPath()
	def file = new File(bootStrapPath)
	if (file.exists()) {
		return bootStrapPath
	}
	null
}
	
def getBootStrapEnablerPath() {
	def pluginEnablerLocation = ""
	def ins_dir = RFT_INSTALL_DIR.toString()
	def install_directory = new File(ins_dir.toString())
	def parentDirectory = install_directory.parent
	if (parentDirectory != null) {
		def dir = new StringBuilder(parentDirectory)
		dir << File.separatorChar << "EclipseEnabler" << File.separatorChar << "plugins" << File.separatorChar
	def enablerPluginFile = null
	def v = []
	def enablerPluginDirectory = new File(dir.toString())
	enablerPluginDirectory.eachFileMatch(~/^${ECLIPSE_ENABLER_PLUGIN}.*/) { file ->
			v << file.name
		}
		v.sort()
		enablerPluginFile = v.last()
		if (enablerPluginFile != null) {
			dir << enablerPluginFile
			pluginEnablerLocation = dir.toString()
		}
	}
	return pluginEnablerLocation + File.separator + BOOTSTRAP_JAR;
}