/*
 * Decompiled with CFR 0.152.
 */
package com.ghc.ghTester.ant;

import com.ghc.ghTester.ant.CommandLineBuilder;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class CommandLineBuilderTest {
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();

    @Test
    public void testBothAppPropertiesAndIniFilePropertiesAreUsed() throws IOException {
        File ini = this.createTempFile("junit.ini", "-vmargs", "-DiniPropertyName=iniPropertyValue");
        File app = this.createTempFile("myApp", new String[0]);
        CommandLineBuilder b = new CommandLineBuilder(app).withVmArgs(Collections.singletonList("-DAppPropertiesPropertyName=AppPropertiesPropertyValue"), ini);
        Assert.assertArrayEquals((Object[])new String[]{app.getAbsolutePath(), "-vmargs", "-DiniPropertyName=iniPropertyValue", "-DAppPropertiesPropertyName=AppPropertiesPropertyValue"}, (Object[])b.build());
    }

    @Test
    public void testAddedPropertyOverwritesIniProperty() throws IOException {
        File ini = this.createTempFile("junit.ini", "-vmargs", "-Dproperty=ini");
        File app = this.createTempFile("myApp", new String[0]);
        CommandLineBuilder b = new CommandLineBuilder(app).withVmArgs(Collections.singletonList("-Dproperty=added"), ini);
        Assert.assertArrayEquals((Object[])new String[]{app.getAbsolutePath(), "-vmargs", "-Dproperty=added"}, (Object[])b.build());
    }

    private File createTempFile(String name, String ... lines) throws IOException {
        File file = this.folder.newFile(name);
        BufferedWriter out = new BufferedWriter(new FileWriter(file));
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            out.write(String.valueOf(string) + "\n");
            ++n2;
        }
        out.close();
        return file;
    }
}

