/*
 * Decompiled with CFR 0.152.
 */
package com.ghc.ghTester.ant;

import com.ghc.ghTester.ant.vie.stubs.ExitCode;
import com.ghc.ghTester.ant.vie.stubs.environment.EnvironmentDeleter;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class DeleteEnvironment
extends Task {
    private String serverURL;
    private String domain;
    private String environment;
    private String username;
    private boolean haltOnFailure = false;
    private String failureProperty = null;

    public void setServerURL(String serverURL) {
        this.serverURL = serverURL;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setHaltOnFailure(boolean haltOnFailure) {
        this.haltOnFailure = haltOnFailure;
    }

    public void setFailureProperty(String failureProperty) {
        this.failureProperty = failureProperty;
    }

    public void execute() throws BuildException {
        this.validateInputs();
        int exitCode = this.deleteEnvironment();
        if (this.haltOnFailure && exitCode != 0) {
            throw new BuildException("DeleteEnvironment exited with code " + exitCode);
        }
        if (this.failureProperty != null && exitCode != 0) {
            this.getProject().setNewProperty(this.failureProperty, "true");
        }
        this.log("DeleteEnvironment exited with code " + exitCode, 2);
    }

    private void validateInputs() throws BuildException {
        if (this.domain == null) {
            throw new BuildException("Domain must be specified");
        }
        if (this.environment == null) {
            throw new BuildException("Base environment must be specified");
        }
        if (this.serverURL == null) {
            throw new BuildException("Server URL must be specified");
        }
    }

    private int deleteEnvironment() {
        try {
            EnvironmentDeleter environmentUpdater = new EnvironmentDeleter(this.serverURL, this.domain, this.environment, this.username);
            ExitCode exitCode = environmentUpdater.delete();
            return exitCode.code;
        }
        catch (Exception e) {
            throw new BuildException("An error occurred while running UpdateEnvironment", (Throwable)e);
        }
    }
}

