/*
 * Decompiled with CFR 0.152.
 */
package com.ghc.ghTester.ant;

import com.ghc.ghTester.ant.vie.stubs.StubStopper;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class StopStub
extends Task {
    private boolean haltOnFailure = false;
    private String failureProperty = null;
    private String serverURL;
    private String domain;
    private String environment;
    private String component;
    private String operation;
    @Deprecated
    private String stub;
    private String name;
    private String version;
    private String async;
    private String username;

    public void execute() throws BuildException {
        this.validateInputs();
        int exitCode = this.stopStub();
        if (this.haltOnFailure && exitCode != 0) {
            throw new BuildException("StartStub exited with code " + exitCode);
        }
        if (this.failureProperty != null && exitCode != 0) {
            this.getProject().setNewProperty(this.failureProperty, "true");
        }
        this.log("StopStub exited with code " + exitCode, 2);
    }

    private void validateInputs() throws BuildException {
        if (this.domain == null) {
            throw new BuildException("Domain must be specified");
        }
        if (this.environment == null) {
            throw new BuildException("Environment must be specified");
        }
        if (this.getName() == null) {
            throw new BuildException("Stub name must be specified");
        }
        if (this.serverURL == null) {
            throw new BuildException("Server URL must be specified");
        }
    }

    private int stopStub() throws BuildException {
        try {
            StubStopper stopper = new StubStopper(this.serverURL, this.domain, this.environment, this.component, this.operation, this.getName(), this.version, this.async != null ? Boolean.parseBoolean(this.async) : false, this.username);
            return stopper.stopStub().code;
        }
        catch (Exception e) {
            throw new BuildException("An error occurred while running StopStub", (Throwable)e);
        }
    }

    public void setHaltOnFailure(boolean haltOnError) {
        this.haltOnFailure = haltOnError;
    }

    public void setFailureProperty(String value) {
        this.failureProperty = value;
    }

    public void setServerURL(String serverURL) {
        this.serverURL = serverURL;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public void setComponent(String component) {
        this.component = component;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    @Deprecated
    public void setStub(String stub) {
        this.stub = stub;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name == null ? this.stub : this.name;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setAsync(String async) {
        this.async = async;
    }

    public void setUsername(String username) {
        this.username = username;
    }
}

