/*
 * Decompiled with CFR 0.152.
 */
package com.ghc.ghTester.ant.vie.scenarios;

import com.ghc.ghTester.ant.vie.VieHttpException;
import com.ghc.ghTester.ant.vie.scenarios.LogOutputWrapper;
import com.ghc.ghTester.ant.vie.scenarios.RtcpScenarioService;
import com.ghc.ghTester.ant.vie.scenarios.ScenarioDetails;
import com.ghc.ghTester.ant.vie.scenarios.ScenarioReference;
import com.ghc.ghTester.ant.vie.scenarios.ScenarioService;
import com.ghc.ghTester.ant.vie.scenarios.ScenarioStopper;
import com.ghc.ghTester.ant.vie.scenarios.StopStubsOption;
import com.ghc.ghTester.ant.vie.scenarios.SysOutLogOutputWrapper;
import com.ghc.ghTester.ant.vie.stubs.ExitCode;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.xml.sax.SAXException;

public class ScenarioStarter {
    private static final Logger log = Logger.getLogger(ScenarioStarter.class.getName());
    private static final ExitCode NO_SCENARIOS_FOUND = ExitCode.TARGET_NOT_FOUND;
    private static final ExitCode MULTIPLE_SCENARIOS_FOUND = ExitCode.MULTIPLE_TARGETS_FOUND;
    private static final ExitCode INVALID_SCENARIO_STATE = ExitCode.UNRECOGNISED_STATUS;
    private final ScenarioService service;
    private final ScenarioStopper scenarioStopper;
    private final boolean async;
    private final boolean force;
    private final StopStubsOption stopStubsOption;
    private final String scenarioName;
    private final String scenarioId;
    private final String owner;
    private final String environment;
    private final String username;
    private final LogOutputWrapper logWrapper;

    public ScenarioStarter(String url, String domain, String environment, String scenarioName, String scenarioId, String owner, boolean async, boolean force, String stopStubsOption, String username, LogOutputWrapper logWrapper) throws URISyntaxException, StopStubsOption.UnrecognisedStopStubOption {
        StopStubsOption option;
        this.service = new RtcpScenarioService(url, domain);
        this.scenarioStopper = new ScenarioStopper(url, domain, environment, scenarioName, scenarioId, owner, username, async, new SysOutLogOutputWrapper());
        this.scenarioName = scenarioName;
        this.scenarioId = scenarioId;
        this.owner = owner;
        this.environment = environment;
        this.async = async;
        this.force = force;
        this.logWrapper = logWrapper;
        this.stopStubsOption = stopStubsOption == null || stopStubsOption.trim().isEmpty() ? StopStubsOption.NONE : (option = StopStubsOption.fromString(stopStubsOption));
        this.username = username;
    }

    public ExitCode startScenario() throws URISyntaxException, ParserConfigurationException, SAXException, TransformerException {
        try {
            block21: {
                ExitCode result;
                List<ScenarioReference> scenarioReferences;
                if (this.username != null) {
                    this.logWrapper.logMessage("Using username: " + this.username);
                }
                try {
                    scenarioReferences = this.service.locateScenarios(this.scenarioName, this.scenarioId, this.owner, this.environment);
                }
                catch (VieHttpException e) {
                    if (e.getStatus() == 404) {
                        this.logWrapper.logMessage("Unable to obtain a list of scenarios from the server, check the server version and URL is correct");
                        return ExitCode.SERVER_CONNECTION_ERROR;
                    }
                    if (e.getStatus() == 412) {
                        this.logWrapper.logMessage("Incorrect domain or environment supplied");
                        return ExitCode.DOMAIN_OR_ENV_NOT_FOUND;
                    }
                    this.logWrapper.logMessage(e.getMessage());
                    return ExitCode.UNRECOGNISED_SERVER_ERROR;
                }
                if (scenarioReferences.isEmpty()) {
                    this.logWrapper.logMessage("No scenarios found matching supplied parameters");
                    return NO_SCENARIOS_FOUND;
                }
                if (scenarioReferences.size() > 1) {
                    this.logWrapper.logMessage("Multiple scenarios found and only 1 can be started at a time, use a more specific set of parameters");
                    return MULTIPLE_SCENARIOS_FOUND;
                }
                ScenarioReference scenarioReference = scenarioReferences.get(0);
                log.finest("Attemping to start: " + scenarioReference);
                this.logWrapper.logMessage("Attemping to start scenario: " + scenarioReference.name);
                try {
                    ExitCode stopResult;
                    result = this.startScenario(scenarioReference, this.stopStubsOption, this.username);
                    if (result == ExitCode.SCENARIO_ALREADY_RUNNING && this.force && (stopResult = this.scenarioStopper.stopScenario()) == ExitCode.SUCCESS) {
                        result = this.startScenario(scenarioReference, this.stopStubsOption, this.username);
                    }
                }
                catch (VieHttpException e) {
                    this.logWrapper.logMessage(e.getMessage());
                    return ExitCode.UNRECOGNISED_SERVER_ERROR;
                }
                if (result != ExitCode.SUCCESS) {
                    return result;
                }
                if (!this.async) {
                    this.logWrapper.logMessage("Waiting for scenario to start...");
                    while (true) {
                        try {
                            while (true) {
                                ScenarioDetails details = this.service.getScenarioDetails(scenarioReference);
                                this.logWrapper.logMessage("Current state: " + details.status);
                                if (!"DEPLOYING".equalsIgnoreCase(details.status)) {
                                    if (!"RUNNING".equalsIgnoreCase(details.status)) {
                                        this.logWrapper.logMessage("Scenario is in an invalid state");
                                        return INVALID_SCENARIO_STATE;
                                    }
                                    break block21;
                                }
                                Thread.sleep(TimeUnit.SECONDS.toMillis(5L));
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            continue;
                        }
                        catch (VieHttpException e) {
                            this.logWrapper.logMessage(e.getMessage());
                            return ExitCode.UNRECOGNISED_SERVER_ERROR;
                        }
                        break;
                    }
                }
                this.logWrapper.logMessage("Scenario will be started in the background.");
            }
            return ExitCode.SUCCESS;
        }
        catch (IOException e) {
            this.logWrapper.logMessage("Could not connect to Rational Test Control Panel.");
            this.logWrapper.logMessage(e.getMessage());
            return ExitCode.SERVER_CONNECTION_ERROR;
        }
    }

    public ExitCode startScenario(ScenarioReference scenarioReference, StopStubsOption stopStubsOption, String username) throws URISyntaxException, IOException, TransformerException, ParserConfigurationException, SAXException, VieHttpException {
        try {
            this.service.startScenario(scenarioReference, stopStubsOption, username);
            return ExitCode.SUCCESS;
        }
        catch (VieHttpException e) {
            if (e.getStatus() == 412) {
                this.logWrapper.logMessage("Incorrect domain or environment supplied");
                return ExitCode.DOMAIN_OR_ENV_NOT_FOUND;
            }
            if (e.getStatus() == 417) {
                this.logWrapper.logMessage("No agents available");
                return ExitCode.AGENT_NOT_FOUND;
            }
            if (e.getStatus() == 400) {
                this.logWrapper.logMessage("Error starting scenario, see server logs for details");
                return ExitCode.UNEXPECTED_REQUEST_ERROR;
            }
            if (e.getStatus() == 409) {
                this.logWrapper.logMessage("A Scenario is already running in this Environment");
                return ExitCode.SCENARIO_ALREADY_RUNNING;
            }
            if (e.getStatus() == 423) {
                this.logWrapper.logMessage(e.getMessage());
                if (username == null) {
                    this.logWrapper.logMessage("Specify the \"username\" option to start a stub in a locked environment.");
                }
                return ExitCode.ENVIRONMENT_LOCKED;
            }
            throw e;
        }
    }
}

