/*
 * Decompiled with CFR 0.152.
 */
package com.ghc.ghTester.ant;

import com.ghc.ghTester.ant.vie.stubs.ExitCode;
import com.ghc.ghTester.ant.vie.stubs.environment.EnvironmentCreator;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class CreateEnvironment
extends Task {
    private String serverURL;
    private String domain;
    private String baseEnvironment;
    private String description;
    private String nameProperty;
    private boolean haltOnFailure = false;
    private String failureProperty = null;

    public void setServerURL(String serverURL) {
        this.serverURL = serverURL;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public void setBaseEnvironment(String baseEnvironment) {
        this.baseEnvironment = baseEnvironment;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setNameProperty(String nameProperty) {
        this.nameProperty = nameProperty;
    }

    public void setHaltOnFailure(boolean haltOnFailure) {
        this.haltOnFailure = haltOnFailure;
    }

    public void setFailureProperty(String failureProperty) {
        this.failureProperty = failureProperty;
    }

    public void execute() throws BuildException {
        this.validateInputs();
        int exitCode = this.createEnvironment();
        if (this.haltOnFailure && exitCode != 0) {
            throw new BuildException("CreateEnvironment exited with code " + exitCode);
        }
        if (this.failureProperty != null && exitCode != 0) {
            this.getProject().setNewProperty(this.failureProperty, "true");
        }
        this.log("CreateEnvironment exited with code " + exitCode, 2);
    }

    private void validateInputs() throws BuildException {
        if (this.domain == null) {
            throw new BuildException("Domain must be specified");
        }
        if (this.baseEnvironment == null) {
            throw new BuildException("Base environment must be specified");
        }
        if (this.serverURL == null) {
            throw new BuildException("Server URL must be specified");
        }
    }

    private int createEnvironment() {
        try {
            EnvironmentCreator environmentCreator = new EnvironmentCreator(this.serverURL, this.domain, this.baseEnvironment, this.description);
            ExitCode exitCode = environmentCreator.create();
            if (this.nameProperty != null) {
                this.getProject().setProperty(this.nameProperty, environmentCreator.getNewEnvironmentName());
            }
            return exitCode.code;
        }
        catch (Exception e) {
            throw new BuildException("An error occurred while running CreateEnvironment", (Throwable)e);
        }
    }
}

