/*
 * Decompiled with CFR 0.152.
 */
package com.ghc.ghTester.ant;

import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileList;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.ResourceCollection;

public class Tests
extends Task {
    private ResourceCollection m_collection;
    private List<String> m_cachedTestPaths;

    public List<String> getRelativeTestPaths() throws BuildException {
        if (this.m_cachedTestPaths == null) {
            this.X_verify();
            ArrayList<String> ret = new ArrayList<String>();
            if (this.m_collection instanceof FileSet) {
                this.X_processFileset((FileSet)this.m_collection, ret);
            } else if (this.m_collection instanceof FileList) {
                this.X_processFilelist((FileList)this.m_collection, ret);
            }
            this.m_cachedTestPaths = ret;
        }
        return this.m_cachedTestPaths;
    }

    private void X_verify() throws BuildException {
        boolean isFileset = this.m_collection instanceof FileSet;
        boolean isFilelist = this.m_collection instanceof FileList;
        if (!isFileset && !isFilelist) {
            throw new BuildException("Must contain one Fileset or Filelist child.");
        }
    }

    private void X_processFileset(FileSet fs, List<String> testPaths) throws BuildException {
        DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
        String[] includedFiles = ds.getIncludedFiles();
        int i = 0;
        while (i < includedFiles.length) {
            testPaths.add(includedFiles[i]);
            ++i;
        }
    }

    private void X_processFilelist(FileList fl, List<String> testPaths) throws BuildException {
        String[] includedFiles = fl.getFiles(this.getProject());
        int i = 0;
        while (i < includedFiles.length) {
            testPaths.add(includedFiles[i]);
            ++i;
        }
    }

    public void addFileset(FileSet fs) throws BuildException {
        this.X_verifyNullCollection();
        this.m_collection = fs;
    }

    public void addFilelist(FileList fl) throws BuildException {
        this.X_verifyNullCollection();
        this.m_collection = fl;
    }

    private void X_verifyNullCollection() throws BuildException {
        if (this.m_collection != null) {
            throw new BuildException("Cannot have more then one Fileset or Filelist child.");
        }
    }
}

