/*
 * Decompiled with CFR 0.152.
 */
package com.ghc.ghTester.ant.vie.scenarios;

import com.ghc.ghTester.ant.vie.DomUtils;
import com.ghc.ghTester.ant.vie.scenarios.ScenarioReference;
import java.io.IOException;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ScenarioReferenceFactory {
    private static final Logger log = Logger.getLogger(ScenarioReferenceFactory.class.getName());
    public static final ScenarioReferenceFactory INSTANCE = new ScenarioReferenceFactory();

    public List<ScenarioReference> createListFromXml(String baseURL, String xml) throws IOException, URISyntaxException, ParserConfigurationException, SAXException, TransformerException {
        LinkedList<ScenarioReference> result = new LinkedList<ScenarioReference>();
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = builderFactory.newDocumentBuilder();
        Document document = builder.parse(new InputSource(new StringReader(xml)));
        Element root = document.getDocumentElement();
        NodeList childNodes = root.getChildNodes();
        if (childNodes != null) {
            int k = 0;
            while (k < childNodes.getLength()) {
                ScenarioReference scenario;
                Node node = childNodes.item(k);
                if (node.getNodeName().equalsIgnoreCase("scenario") && node instanceof Element && (scenario = this.buildScenarioRef(baseURL, (Element)node)) != null) {
                    result.add(scenario);
                }
                ++k;
            }
        }
        return result;
    }

    private ScenarioReference buildScenarioRef(String baseURL, Element element) throws URISyntaxException, TransformerException, ParserConfigurationException {
        String href = element.getAttribute("href");
        String name = element.getAttribute("name");
        String id = element.getAttribute("id");
        if (href != null) {
            URI uri = new URI(baseURL);
            href = uri.resolve(href).toString();
            ScenarioReference scenarioRef = new ScenarioReference(id, href, name);
            return scenarioRef;
        }
        log.severe("Unable to build StubDefinition from XML, href could not be found: " + DomUtils.toXML(element));
        return null;
    }
}

