/*
 * Decompiled with CFR 0.152.
 */
package com.ghc.ghTester.ant.vie.scenarios;

import com.ghc.ghTester.ant.vie.VieHttpException;
import com.ghc.ghTester.ant.vie.scenarios.LogOutputWrapper;
import com.ghc.ghTester.ant.vie.scenarios.RtcpScenarioService;
import com.ghc.ghTester.ant.vie.scenarios.ScenarioDetails;
import com.ghc.ghTester.ant.vie.scenarios.ScenarioReference;
import com.ghc.ghTester.ant.vie.scenarios.ScenarioService;
import com.ghc.ghTester.ant.vie.stubs.ExitCode;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.xml.sax.SAXException;

public class ScenarioStopper {
    private static final Logger log = Logger.getLogger(ScenarioStopper.class.getName());
    private static final ExitCode NO_DOMAIN_OR_ENV = ExitCode.DOMAIN_OR_ENV_NOT_FOUND;
    private static final ExitCode NO_SCENARIOS_FOUND = ExitCode.TARGET_NOT_FOUND;
    private static final ExitCode MULTIPLE_SCENARIOS_FOUND = ExitCode.MULTIPLE_TARGETS_FOUND;
    private static final ExitCode INVALID_SCENARIO_STATE = ExitCode.SCENARIO_ALREADY_RUNNING;
    private final ScenarioService service;
    private final boolean async;
    private final String scenarioName;
    private final String scenarioId;
    private final String owner;
    private final String environment;
    private final String username;
    private final LogOutputWrapper logWrapper;

    public ScenarioStopper(String url, String domain, String environment, String scenarioName, String scenarioId, String owner, String username, boolean async, LogOutputWrapper logWrapper) throws URISyntaxException {
        this.service = new RtcpScenarioService(url, domain);
        this.scenarioName = scenarioName;
        this.scenarioId = scenarioId;
        this.owner = owner;
        this.environment = environment;
        this.username = username;
        this.async = async;
        this.logWrapper = logWrapper;
    }

    public ExitCode stopScenario() throws URISyntaxException, ParserConfigurationException, SAXException, TransformerException {
        try {
            block22: {
                List<ScenarioReference> scenarioReferences;
                if (this.username != null) {
                    this.logWrapper.logMessage("Using username: " + this.username);
                }
                try {
                    scenarioReferences = this.service.locateScenarios(this.scenarioName, this.scenarioId, this.owner, this.environment);
                }
                catch (VieHttpException e) {
                    if (e.getStatus() == 404) {
                        this.logWrapper.logMessage("Unable to obtain a list of Scenarios from the server, check the server version and URL is correct");
                        return ExitCode.SERVER_CONNECTION_ERROR;
                    }
                    if (e.getStatus() == 412) {
                        this.logWrapper.logMessage("Incorrect domain or environment supplied");
                        return ExitCode.DOMAIN_OR_ENV_NOT_FOUND;
                    }
                    this.logWrapper.logMessage(e.getMessage());
                    return ExitCode.UNRECOGNISED_SERVER_ERROR;
                }
                if (scenarioReferences.isEmpty()) {
                    this.logWrapper.logMessage("No scenarios found matching supplied parameters");
                    return NO_SCENARIOS_FOUND;
                }
                if (scenarioReferences.size() > 1) {
                    this.logWrapper.logMessage("Multiple scenarios found and only 1 can be stopped at a time, use a more specific set of parameters");
                    return MULTIPLE_SCENARIOS_FOUND;
                }
                ScenarioReference scenarioReference = scenarioReferences.get(0);
                log.finest("Stopping scenario: " + scenarioReference);
                this.logWrapper.logMessage("Stopping scenario: " + scenarioReference.name);
                try {
                    this.service.stopScenario(scenarioReference, this.username);
                }
                catch (VieHttpException e) {
                    if (e.getStatus() == 412) {
                        this.logWrapper.logMessage("Incorrect domain or environment supplied");
                        return NO_DOMAIN_OR_ENV;
                    }
                    if (e.getStatus() == 423) {
                        this.logWrapper.logMessage(e.getMessage());
                        if (this.username == null) {
                            this.logWrapper.logMessage("Specify the \"username\" option to start a stub in a locked environment.");
                        }
                        return ExitCode.ENVIRONMENT_LOCKED;
                    }
                    this.logWrapper.logMessage(e.getMessage());
                    return ExitCode.UNRECOGNISED_SERVER_ERROR;
                }
                if (!this.async) {
                    try {
                        this.logWrapper.logMessage("Waiting for scenario to stop...");
                        while (true) {
                            ScenarioDetails details = this.service.getScenarioDetails(scenarioReference);
                            this.logWrapper.logMessage("Current state: " + details.status);
                            if (!"STOPPING".equals(details.status)) {
                                if (!"STOPPED".equalsIgnoreCase(details.status)) {
                                    this.logWrapper.logMessage("Scenario is in an invalid state");
                                    return INVALID_SCENARIO_STATE;
                                }
                                break block22;
                            }
                            try {
                                Thread.sleep(TimeUnit.SECONDS.toMillis(5L));
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                    }
                    catch (VieHttpException e) {
                        this.logWrapper.logMessage(e.getMessage());
                        return ExitCode.UNRECOGNISED_SERVER_ERROR;
                    }
                }
                this.logWrapper.logMessage("Scenario will be stopped in the background.");
            }
            return ExitCode.SUCCESS;
        }
        catch (IOException e) {
            this.logWrapper.logMessage("Could not connect to Rational Test Control Panel.");
            this.logWrapper.logMessage(e.getMessage());
            return ExitCode.SERVER_CONNECTION_ERROR;
        }
    }
}

