/*
 * Decompiled with CFR 0.152.
 */
package com.ghc.ghTester.ant.vie.stubs;

import com.ghc.ghTester.ant.vie.DomUtils;
import com.ghc.ghTester.ant.vie.stubs.StubDefinition;
import java.io.IOException;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class StubDefinitionFactory {
    private static final Logger log = Logger.getLogger(StubDefinitionFactory.class.getName());
    public static final StubDefinitionFactory INSTANCE = new StubDefinitionFactory();

    public List<StubDefinition> createListFromXml(String baseURL, String xml) throws IOException, URISyntaxException, ParserConfigurationException, SAXException, TransformerException {
        LinkedList<StubDefinition> result = new LinkedList<StubDefinition>();
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = builderFactory.newDocumentBuilder();
        Document document = builder.parse(new InputSource(new StringReader(xml)));
        Element root = document.getDocumentElement();
        NodeList childNodes = root.getChildNodes();
        if (childNodes != null) {
            int k = 0;
            while (k < childNodes.getLength()) {
                StubDefinition stub;
                Node node = childNodes.item(k);
                if (node.getNodeName().equalsIgnoreCase("stub") && node instanceof Element && (stub = this.buildStubDef(baseURL, (Element)node)) != null) {
                    result.add(stub);
                }
                ++k;
            }
        }
        return result;
    }

    public StubDefinition createFromXml(String baseURL, String xml) throws IOException, URISyntaxException, ParserConfigurationException, SAXException, TransformerException {
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = builderFactory.newDocumentBuilder();
        Document document = builder.parse(new InputSource(new StringReader(xml)));
        Element element = document.getDocumentElement();
        if (element != null) {
            StubDefinition stub = this.buildStubDef(baseURL, element);
            return stub;
        }
        return null;
    }

    public StubDefinition buildStubDef(String baseURL, Element element) throws URISyntaxException, TransformerException, ParserConfigurationException {
        String id = element.getAttribute("id");
        String href = element.getAttribute("href");
        String version = element.getAttribute("version");
        String name = element.getAttribute("name");
        String component = null;
        if (element.hasAttribute("component")) {
            component = element.getAttribute("component");
        }
        String operation = null;
        if (element.hasAttribute("operation")) {
            operation = element.getAttribute("operation");
        }
        if (href != null) {
            URI uri = new URI(baseURL);
            href = uri.resolve(href).toString();
            StubDefinition stubDef = new StubDefinition(href, id, version, name, component, operation);
            return stubDef;
        }
        log.severe("Unable to build StubDefinition from XML, href could not be found: " + DomUtils.toXML(element));
        return null;
    }
}

