/*
 * Decompiled with CFR 0.152.
 */
package com.ghc.ghTester.ant.vie.stubs;

import com.ghc.ghTester.ant.vie.DomUtils;
import com.ghc.ghTester.ant.vie.HttpClient;
import com.ghc.ghTester.ant.vie.VieHttpClient;
import com.ghc.ghTester.ant.vie.VieHttpException;
import com.ghc.ghTester.ant.vie.stubs.ResponseTimeConfiguration;
import com.ghc.ghTester.ant.vie.stubs.StubDefinition;
import com.ghc.ghTester.ant.vie.stubs.StubDefinitionFactory;
import com.ghc.ghTester.ant.vie.stubs.StubInstance;
import com.ghc.ghTester.ant.vie.stubs.StubInstanceFactory;
import com.ghc.ghTester.ant.vie.stubs.StubsService;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.util.URIUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class StubsServiceImpl
implements StubsService {
    private static final Logger log = Logger.getLogger(StubsServiceImpl.class.getName());
    private final HttpClient client;
    private final URI baseURI;
    private final String domain;
    private final String environment;
    private final String component;
    private final String operation;
    private final String operationId;
    private final String stubId;
    private final String name;
    private final String version;
    private final DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();

    public StubsServiceImpl(String serverUrl, String domain, String environment, String component, String operation, String operationId, String stubId, String name, String version) throws URISyntaxException {
        this.client = new VieHttpClient();
        String url = serverUrl;
        if (!url.endsWith("/")) {
            url = String.valueOf(url) + "/";
        }
        URI root = new URI(url);
        this.baseURI = root.resolve("rest/stubs/");
        this.domain = domain;
        this.environment = environment;
        this.component = component;
        this.operation = operation;
        this.operationId = operationId;
        this.stubId = stubId;
        this.name = name;
        this.version = version;
    }

    @Override
    public List<StubDefinition> locateStubs() throws IOException, VieHttpException, URISyntaxException, ParserConfigurationException, SAXException, TransformerException {
        String queryOptions = this.createQueryString();
        String queryURL = this.baseURI.resolve(queryOptions).toString();
        String xml = this.client.get(queryURL);
        List<StubDefinition> list = StubDefinitionFactory.INSTANCE.createListFromXml(this.baseURI.toString(), xml);
        return list;
    }

    @Override
    public StubInstance startStub(StubDefinition stubDefinition, ResponseTimeConfiguration responseTime, List<String> attributes, String username) throws URISyntaxException, IOException, VieHttpException, TransformerException, ParserConfigurationException, SAXException {
        DocumentBuilder docBuilder = this.documentBuilderFactory.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        Element startStub = doc.createElement("start-stub");
        if (responseTime != null) {
            Element config = doc.createElement("configuration");
            startStub.appendChild(config);
            Element responseTimeElement = doc.createElement("response-time");
            config.appendChild(responseTimeElement);
            if (responseTime.distribution != null) {
                responseTimeElement.setAttribute("distribution", responseTime.distribution.name());
            }
            responseTimeElement.setAttribute("minimum", String.valueOf(responseTime.min));
            responseTimeElement.setAttribute("maximum", String.valueOf(responseTime.max));
        }
        if (attributes != null && !attributes.isEmpty()) {
            Element agents = doc.createElement("agents");
            startStub.appendChild(agents);
            Element agent = doc.createElement("agent");
            agents.appendChild(agent);
            Element attrs = doc.createElement("attributes");
            agent.appendChild(attrs);
            for (String attribute : attributes) {
                Element attr = doc.createElement("attribute");
                attr.setAttribute("value", attribute);
                attrs.appendChild(attr);
            }
        }
        doc.appendChild(startStub);
        this.client.setCredentials(username);
        String postURL = stubDefinition.getHref();
        String outputXML = this.client.post(postURL, DomUtils.toXML(doc), null);
        StubInstance instance = StubInstanceFactory.INSTANCE.fromXML(postURL, outputXML);
        return instance;
    }

    @Override
    public StubInstance getInstance(StubInstance instance) throws IOException, VieHttpException, URISyntaxException, ParserConfigurationException, SAXException, TransformerException {
        String url = instance.getHref();
        try {
            String xml = this.client.get(url);
            StubInstance res = new StubInstance(instance, xml);
            return res;
        }
        catch (VieHttpException e) {
            if (e.getStatus() == 404 || e.getStatus() == 412) {
                return null;
            }
            throw e;
        }
    }

    @Override
    public List<StubInstance> getInstances(StubDefinition stubDef) throws IOException, URISyntaxException, VieHttpException, TransformerException, ParserConfigurationException, SAXException {
        String stubDefUrl = stubDef.getHref();
        String stubInstancesUrl = String.valueOf(stubDefUrl) + "instances/";
        try {
            String xml = this.client.get(stubInstancesUrl);
            List<StubInstance> instances = StubInstanceFactory.INSTANCE.listFromXML(stubInstancesUrl, xml);
            return instances;
        }
        catch (VieHttpException e) {
            if (e.getStatus() == 404 || e.getStatus() == 412) {
                return null;
            }
            throw e;
        }
    }

    @Override
    public void stopInstance(StubInstance instance, String username) throws IOException, VieHttpException {
        block2: {
            String url = instance.getHref();
            try {
                this.client.setCredentials(username);
                this.client.delete(url, null);
            }
            catch (VieHttpException e) {
                if (e.getStatus() == 404 || e.getStatus() == 412) break block2;
                throw e;
            }
        }
    }

    private String createQueryString() {
        StringBuilder builder = new StringBuilder();
        builder.append("?domain=");
        builder.append(StubsServiceImpl.processQueryStringValue(this.domain));
        if (this.environment != null) {
            builder.append("&env=");
            builder.append(StubsServiceImpl.processQueryStringValue(this.environment));
        }
        if (this.component != null) {
            builder.append("&comp=");
            builder.append(StubsServiceImpl.processQueryStringValue(this.component));
        }
        if (this.operation != null) {
            builder.append("&op=");
            builder.append(StubsServiceImpl.processQueryStringValue(this.operation));
        }
        if (this.stubId != null) {
            builder.append("&id=");
            builder.append(StubsServiceImpl.processQueryStringValue(this.stubId));
        }
        if (this.name != null) {
            builder.append("&stub=");
            builder.append(StubsServiceImpl.processQueryStringValue(this.name));
        }
        if (this.version != null) {
            builder.append("&version=");
            builder.append(StubsServiceImpl.processQueryStringValue(this.version));
        }
        if (this.operationId != null) {
            builder.append("&operationId=");
            builder.append(StubsServiceImpl.processQueryStringValue(this.operationId));
        }
        return builder.toString();
    }

    private static String processQueryStringValue(String value) {
        try {
            return URIUtil.encodeWithinQuery((String)value, (String)"UTF-8");
        }
        catch (URIException e) {
            log.log(Level.SEVERE, "Could not encode query string value", e);
            return value;
        }
    }
}

