/*
 * Decompiled with CFR 0.152.
 */
package com.ghc.ghTester.ant.vie.stubs.environment;

import com.ghc.ghTester.ant.vie.VieHttpException;
import com.ghc.ghTester.ant.vie.stubs.ExitCode;
import com.ghc.ghTester.ant.vie.stubs.environment.EnvironmentDefinition;
import com.ghc.ghTester.ant.vie.stubs.environment.EnvironmentService;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URISyntaxException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.xml.sax.SAXException;

public class EnvironmentCreator {
    private static final PrintStream OUT = System.out;
    private final String baseEnvironmentName;
    private final String description;
    private String newEnvironmentName;
    private final EnvironmentService service;

    public EnvironmentCreator(String serverURL, String domain, String baseEnvironmentName, String description) throws URISyntaxException {
        this.baseEnvironmentName = baseEnvironmentName;
        this.description = description;
        this.service = new EnvironmentService(serverURL, domain);
    }

    public ExitCode create() throws URISyntaxException, ParserConfigurationException, SAXException, TransformerException {
        try {
            EnvironmentDefinition createdEnvironment;
            EnvironmentDefinition input = new EnvironmentDefinition(null, null, this.baseEnvironmentName, null, this.description, null, false, null);
            try {
                createdEnvironment = this.service.createEnvironment(input);
            }
            catch (VieHttpException e) {
                if (e.getStatus() == 412) {
                    OUT.println("Unable to find the base environment on Rational Test Control Panel, check supplied parameters.");
                    OUT.println(e.getMessage());
                    return ExitCode.DOMAIN_OR_ENV_NOT_FOUND;
                }
                OUT.println(e.getMessage());
                return ExitCode.UNRECOGNISED_SERVER_ERROR;
            }
            if (createdEnvironment == null) {
                OUT.println("Unable to create the environment on Rational Test Control Panel, check supplied parameters.");
                return ExitCode.ACTION_ERROR;
            }
            this.newEnvironmentName = createdEnvironment.getName();
            return ExitCode.SUCCESS;
        }
        catch (IOException e) {
            OUT.println("Could not connect to Rational Test Control Panel.");
            OUT.println(e.getMessage());
            return ExitCode.SERVER_CONNECTION_ERROR;
        }
    }

    public String getNewEnvironmentName() {
        return this.newEnvironmentName;
    }
}

