/*
 * Decompiled with CFR 0.152.
 */
package com.ghc.ghTester.ant.vie.stubs.environment;

import com.ghc.ghTester.ant.vie.VieHttpException;
import com.ghc.ghTester.ant.vie.stubs.ExitCode;
import com.ghc.ghTester.ant.vie.stubs.environment.EnvironmentDefinition;
import com.ghc.ghTester.ant.vie.stubs.environment.EnvironmentLockDefinition;
import com.ghc.ghTester.ant.vie.stubs.environment.EnvironmentService;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URISyntaxException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.xml.sax.SAXException;

public class EnvironmentUnLocker {
    private static final PrintStream OUT = System.out;
    private static final ExitCode UNABLE_TO_UNLOCK = ExitCode.UNAUTHORISED;
    private final EnvironmentService service;
    private final String username;
    private final String environment;

    public EnvironmentUnLocker(String url, String domain, String environment, String username) throws URISyntaxException {
        this.environment = environment;
        this.username = username;
        this.service = new EnvironmentService(url, domain);
    }

    public ExitCode unlock() throws URISyntaxException, ParserConfigurationException, SAXException, TransformerException {
        try {
            EnvironmentLockDefinition existingLockDetails;
            EnvironmentDefinition env;
            try {
                env = this.service.locateEnvironment(this.environment);
            }
            catch (VieHttpException e) {
                OUT.println("Unable to find the domain on Rational Test Control Panel, check supplied parameters.");
                OUT.println(e.getMessage());
                return ExitCode.DOMAIN_OR_ENV_NOT_FOUND;
            }
            if (env == null) {
                OUT.println("Unable to find the environment on Rational Test Control Panel, check supplied parameters.");
                return ExitCode.ACTION_ERROR;
            }
            if (!env.isLocked()) {
                return ExitCode.SUCCESS;
            }
            try {
                existingLockDetails = this.service.getLockDetails(env);
            }
            catch (VieHttpException e) {
                OUT.println(e.getMessage());
                return ExitCode.UNRECOGNISED_SERVER_ERROR;
            }
            EnvironmentLockDefinition deleteDetails = new EnvironmentLockDefinition(this.username, null, null, null, existingLockDetails.getHRef());
            try {
                this.service.removeLock(deleteDetails);
            }
            catch (VieHttpException e) {
                if (e.getStatus() == 403) {
                    OUT.println("Unable to unlock as the supplied user does not own the lock");
                    return UNABLE_TO_UNLOCK;
                }
                if (e.getStatus() == 404) {
                    return ExitCode.SUCCESS;
                }
                if (e.getStatus() == 412) {
                    OUT.println("Unable to find the environment during unlocking, check supplied parameters");
                    return ExitCode.DOMAIN_OR_ENV_NOT_FOUND;
                }
                OUT.println(e.getMessage());
                return ExitCode.UNRECOGNISED_SERVER_ERROR;
            }
            return ExitCode.SUCCESS;
        }
        catch (IOException e) {
            OUT.println("Could not connect to Rational Test Control Panel.");
            OUT.println(e.getMessage());
            return ExitCode.SERVER_CONNECTION_ERROR;
        }
    }
}

