/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.externalsort;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.urbancode.commons.util.Check;
import com.urbancode.commons.util.externalsort.DefaultExternalSort;
import com.urbancode.commons.util.externalsort.ExternalSort;
import com.urbancode.commons.util.externalsort.NaturalComparator;
import com.urbancode.commons.util.externalsort.RecordIOFactory;
import java.io.File;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@BridgeMethodsAdded
public class ExternalSortBuilder<T> {
    private static final int MIN_MAX_RECORDS_IN_MEMORY = 2;
    private static final int MIN_MAX_OPEN_FILES = 3;
    private RecordIOFactory<T> factory;
    private int maxRecordsInMemory = 65536;
    private int maxOpenFiles = 5;
    private Comparator<? super T> comparator;
    private File tempDirectory;

    public ExternalSortBuilder(RecordIOFactory<T> factory) {
        this.factory = Check.nonNull(factory, "factory");
    }

    public ExternalSortBuilder<T> factory(RecordIOFactory<T> factory) {
        this.factory = Check.nonNull(factory, "factory");
        return this;
    }

    public RecordIOFactory<T> factory() {
        return this.factory;
    }

    public ExternalSortBuilder<T> maxRecordsInMemory(int maxRecordsInMemory) {
        if (maxRecordsInMemory < 2) {
            throw new IllegalStateException("maxRecordsInMemory < 2");
        }
        this.maxRecordsInMemory = maxRecordsInMemory;
        return this;
    }

    public int maxRecordsInMemory() {
        return this.maxRecordsInMemory;
    }

    public ExternalSortBuilder<T> maxOpenFiles(int maxOpenFiles) {
        if (maxOpenFiles < 3) {
            throw new IllegalStateException("maxOpenFiles < 3");
        }
        this.maxOpenFiles = maxOpenFiles;
        return this;
    }

    public int maxOpenFiles() {
        return this.maxOpenFiles;
    }

    public ExternalSortBuilder<T> tempDirectory(File tempDirectory) {
        this.tempDirectory = tempDirectory;
        return this;
    }

    public File tempDirectory() {
        return this.tempDirectory;
    }

    public ExternalSortBuilder<T> comparator(Comparator<? super T> comparator) {
        this.comparator = comparator;
        return this;
    }

    public Comparator<? super T> comparator() {
        return this.comparator;
    }

    public ExternalSort<T> build() {
        RecordIOFactory<T> factory = this.factory;
        int maxRecordsInMemory = this.maxRecordsInMemory;
        int maxOpenFiles = this.maxOpenFiles;
        File tempDirectory = this.tempDirectory;
        Comparator<? super T> comparator = this.comparator;
        if (factory == null) {
            throw new IllegalStateException("factory is not defined");
        }
        if (maxRecordsInMemory < 2) {
            throw new IllegalStateException("maxRecordsInMemory < 2");
        }
        if (maxOpenFiles < 3) {
            throw new IllegalStateException("maxOpenFiles < 3");
        }
        if (maxRecordsInMemory < maxOpenFiles - 1) {
            throw new IllegalStateException("maxRecordsInMemory < maxOpenFiles");
        }
        if (comparator == null) {
            comparator = new NaturalComparator<T>();
        }
        return new DefaultExternalSort<T>(factory, maxRecordsInMemory, maxOpenFiles, tempDirectory, comparator);
    }
}

