/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.immutable;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@BridgeMethodsAdded
final class Util {
    static final Object[] EMPTY_ARRAY = new Object[0];

    static boolean equals(Object k1, Object k2) {
        if (k1 == k2) {
            return true;
        }
        return k1 != null && k1.equals(k2);
    }

    public static int hash(Object o) {
        if (o == null) {
            return 0;
        }
        return o.hashCode();
    }

    static <A> A[] newArray(Class<A> componentType, int length) {
        return (Object[])Array.newInstance(componentType, length);
    }

    static <A> Class<A> componentType(Object array) {
        return array.getClass().getComponentType();
    }

    static <T, E> E[] toArray(int size, Iterator<T> itr, E[] array) {
        if (array.length < size) {
            array = Util.newArray(Util.componentType(array), size);
        }
        int i = 0;
        while (itr.hasNext()) {
            array[i] = itr.next();
            ++i;
        }
        if (array.length > size) {
            array[size] = null;
        }
        return array;
    }

    static <T> Object[] toArray(int size, Iterator<T> itr) {
        Object[] array = new Object[size];
        int i = 0;
        while (itr.hasNext()) {
            array[i] = itr.next();
            ++i;
        }
        return array;
    }

    static <T> String toString(Object self, Iterator<T> i) {
        if (!i.hasNext()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        while (true) {
            T e;
            sb.append((Object)((e = i.next()) == self ? "(this Collection)" : e));
            if (!i.hasNext()) {
                return sb.append(']').toString();
            }
            sb.append(", ");
        }
    }

    static <T> int hashCode(List<T> list) {
        int hash = 1;
        for (T t : list) {
            hash = 31 * hash + (t == null ? 0 : t.hashCode());
        }
        return hash;
    }

    static <T> boolean equals(List<T> self, Object object) {
        if (object == self) {
            return true;
        }
        if (!(object instanceof List)) {
            return false;
        }
        Iterator<T> e1 = self.iterator();
        Iterator e2 = ((List)object).iterator();
        while (e1.hasNext() && e2.hasNext()) {
            T o1 = e1.next();
            Object o2 = e2.next();
            if (o1 != null ? o1.equals(o2) : o2 == null) continue;
            return false;
        }
        return !e1.hasNext() && !e2.hasNext();
    }

    private Util() {
    }
}

