/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.logging;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import java.text.DecimalFormatSymbols;
import java.util.Formatter;
import java.util.Locale;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

@BridgeMethodsAdded
public class PerfLogger {
    final Logger log;
    final String category;
    long startTime = System.nanoTime();

    protected PerfLogger(Logger log, String category) {
        this.log = log;
        this.category = category;
    }

    public void reset() {
        this.startTime = System.nanoTime();
    }

    public void trace(String message) {
        this.log(Level.TRACE, message);
    }

    public void trace(String message, Throwable t) {
        this.log(Level.TRACE, message, t);
    }

    public void info(String message) {
        this.log(Level.INFO, message);
    }

    public void info(String message, Throwable t) {
        this.log(Level.INFO, message, t);
    }

    public void debug(String message) {
        this.log(Level.DEBUG, message);
    }

    public void debug(String message, Throwable t) {
        this.log(Level.DEBUG, message, t);
    }

    public void warn(String message) {
        this.log(Level.WARN, message);
    }

    public void warn(String message, Throwable t) {
        this.log(Level.WARN, message, t);
    }

    public void log(Level lvl, String message) {
        if (this.log.isEnabledFor((Priority)lvl)) {
            long duration = System.nanoTime() - this.startTime;
            this.log.log((Priority)lvl, (Object)this.format(message, duration));
        }
    }

    public void log(Level lvl, String message, Throwable t) {
        if (this.log.isEnabledFor((Priority)lvl)) {
            this.log.log((Priority)lvl, (Object)this.format(message), t);
        }
    }

    public boolean isDebugEnabled() {
        return this.log.isDebugEnabled();
    }

    public boolean isEnabledFor(Level lvl) {
        return this.log.isEnabledFor((Priority)lvl);
    }

    public String format(String message) {
        long duration = System.nanoTime() - this.startTime;
        return this.format(message, duration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String format(String message, long nanos) {
        Formatter formatter = new Formatter(Locale.US);
        try {
            long millis = nanos / 1000000L;
            char decimal = '.';
            Locale locale = formatter.locale();
            if (locale != null) {
                DecimalFormatSymbols symbols = new DecimalFormatSymbols(locale);
                decimal = symbols.getDecimalSeparator();
            }
            formatter.format("[%s, duration=%,d%c%03d] %s", this.category, millis / 1000L, Character.valueOf(decimal), millis % 1000L, message);
            String string = formatter.toString();
            return string;
        }
        finally {
            formatter.close();
        }
    }
}

