/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.shell;

import java.io.File;
import java.util.StringTokenizer;
import java.util.Vector;

public class ApacheCommandline
implements Cloneable {
    public static final String LINE_SEP = System.getProperty("line.separator");
    private Vector<Argument> arguments = new Vector();
    private String executable = null;
    protected static final String DISCLAIMER = LINE_SEP + "The ' characters around the executable and arguments are" + LINE_SEP + "not part of the command." + LINE_SEP;

    public ApacheCommandline(String to_process) {
        this(to_process, false);
    }

    public ApacheCommandline(String to_process, boolean keepQuotes) {
        String[] tmp = ApacheCommandline.translateCommandline(to_process, keepQuotes);
        if (tmp != null && tmp.length > 0) {
            this.setExecutable(tmp[0]);
            for (int i = 1; i < tmp.length; ++i) {
                this.createArgument().setValue(tmp[i]);
            }
        }
    }

    public ApacheCommandline() {
    }

    public Argument createArgument() {
        return this.createArgument(false);
    }

    public Argument createArgument(boolean insertAtStart) {
        Argument argument = new Argument();
        if (insertAtStart) {
            this.arguments.insertElementAt(argument, 0);
        } else {
            this.arguments.addElement(argument);
        }
        return argument;
    }

    public void setExecutable(String executable) {
        if (executable == null || executable.length() == 0) {
            return;
        }
        this.executable = executable.replace('/', File.separatorChar).replace('\\', File.separatorChar);
    }

    public String getExecutable() {
        return this.executable;
    }

    public void addArguments(String[] line) {
        for (String element : line) {
            this.createArgument().setValue(element);
        }
    }

    public String[] getCommandline() {
        String[] args = this.getArguments();
        if (this.executable == null) {
            return args;
        }
        String[] result = new String[args.length + 1];
        result[0] = this.executable;
        System.arraycopy(args, 0, result, 1, args.length);
        return result;
    }

    public String[] getArguments() {
        Vector<String> result = new Vector<String>(this.arguments.size() * 2);
        for (int i = 0; i < this.arguments.size(); ++i) {
            Argument arg = this.arguments.elementAt(i);
            String[] s = arg.getParts();
            if (s == null) continue;
            for (String element : s) {
                result.addElement(element);
            }
        }
        Object[] res = new String[result.size()];
        result.copyInto(res);
        return res;
    }

    public String toString() {
        return ApacheCommandline.toString(this.getCommandline());
    }

    public static String quoteArgument(String argument) {
        if (argument.indexOf("\"") > -1) {
            if (argument.indexOf("'") > -1) {
                throw new IllegalArgumentException("Can't handle single and double quotes in same argument");
            }
            return '\'' + argument + '\'';
        }
        if (argument.indexOf("'") > -1 || argument.indexOf(" ") > -1) {
            return '\"' + argument + '\"';
        }
        return argument;
    }

    public static String toString(String[] line) {
        if (line == null || line.length == 0) {
            return "";
        }
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < line.length; ++i) {
            if (i > 0) {
                result.append(' ');
            }
            result.append(ApacheCommandline.quoteArgument(line[i]));
        }
        return result.toString();
    }

    public static String[] translateCommandline(String to_process) {
        return ApacheCommandline.translateCommandline(to_process, false);
    }

    public static String[] translateCommandline(String to_process, boolean keepQuotes) {
        if (to_process == null || to_process.length() == 0) {
            return new String[0];
        }
        boolean normal = false;
        boolean inQuote = true;
        int inDoubleQuote = 2;
        int state = 0;
        StringTokenizer tok = new StringTokenizer(to_process, "\"' ", true);
        Vector<String> v = new Vector<String>();
        StringBuffer current = new StringBuffer();
        boolean lastTokenHasBeenQuoted = false;
        block4: while (tok.hasMoreTokens()) {
            String nextTok = tok.nextToken();
            switch (state) {
                case 1: {
                    if ("'".equals(nextTok)) {
                        lastTokenHasBeenQuoted = true;
                        if (keepQuotes) {
                            current.append("'");
                        }
                        state = 0;
                        continue block4;
                    }
                    current.append(nextTok);
                    continue block4;
                }
                case 2: {
                    if ("\"".equals(nextTok)) {
                        lastTokenHasBeenQuoted = true;
                        if (keepQuotes) {
                            current.append("\"");
                        }
                        state = 0;
                        continue block4;
                    }
                    current.append(nextTok);
                    continue block4;
                }
            }
            if ("'".equals(nextTok)) {
                if (keepQuotes) {
                    current.append("'");
                }
                state = 1;
            } else if ("\"".equals(nextTok)) {
                if (keepQuotes) {
                    current.append("\"");
                }
                state = 2;
            } else if (" ".equals(nextTok)) {
                if (lastTokenHasBeenQuoted || current.length() != 0) {
                    v.addElement(current.toString());
                    current.setLength(0);
                }
            } else {
                current.append(nextTok);
            }
            lastTokenHasBeenQuoted = false;
        }
        if (lastTokenHasBeenQuoted || current.length() != 0) {
            v.addElement(current.toString());
        }
        if (state == 1 || state == 2) {
            throw new IllegalArgumentException("unbalanced quotes in " + to_process);
        }
        Object[] args = new String[v.size()];
        v.copyInto(args);
        return args;
    }

    public int size() {
        return this.getCommandline().length;
    }

    public Object clone() {
        ApacheCommandline c = new ApacheCommandline();
        c.setExecutable(this.executable);
        c.addArguments(this.getArguments());
        return c;
    }

    public void clear() {
        this.executable = null;
        this.arguments.removeAllElements();
    }

    public void clearArgs() {
        this.arguments.removeAllElements();
    }

    public Marker createMarker() {
        return new Marker(this.arguments.size());
    }

    public String describeCommand() {
        return ApacheCommandline.describeCommand(this);
    }

    public String describeArguments() {
        return ApacheCommandline.describeArguments(this);
    }

    public static String describeCommand(ApacheCommandline line) {
        return ApacheCommandline.describeCommand(line.getCommandline());
    }

    public static String describeArguments(ApacheCommandline line) {
        return ApacheCommandline.describeArguments(line.getArguments());
    }

    public static String describeCommand(String[] args) {
        if (args == null || args.length == 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer("Executing '");
        buf.append(args[0]);
        buf.append("'");
        if (args.length > 0) {
            buf.append(" with ");
            buf.append(ApacheCommandline.describeArguments(args, 1));
        } else {
            buf.append(DISCLAIMER);
        }
        return buf.toString();
    }

    public static String describeArguments(String[] args) {
        return ApacheCommandline.describeArguments(args, 0);
    }

    protected static String describeArguments(String[] args, int offset) {
        if (args == null || args.length <= offset) {
            return "";
        }
        StringBuffer buf = new StringBuffer("argument");
        if (args.length > offset) {
            buf.append("s");
        }
        buf.append(":").append(LINE_SEP);
        for (int i = offset; i < args.length; ++i) {
            buf.append("'").append(args[i]).append("'").append(LINE_SEP);
        }
        buf.append(DISCLAIMER);
        return buf.toString();
    }

    public class Marker {
        private int position;
        private int realPos = -1;

        Marker(int position) {
            this.position = position;
        }

        public int getPosition() {
            if (this.realPos == -1) {
                this.realPos = ApacheCommandline.this.executable == null ? 0 : 1;
                for (int i = 0; i < this.position; ++i) {
                    Argument arg = (Argument)ApacheCommandline.this.arguments.elementAt(i);
                    this.realPos += arg.getParts().length;
                }
            }
            return this.realPos;
        }
    }

    public static class Argument {
        private String[] parts;

        public void setValue(String value) {
            this.parts = new String[]{value};
        }

        public void setLine(String line) {
            if (line == null) {
                return;
            }
            this.parts = ApacheCommandline.translateCommandline(line);
        }

        public void setFile(File value) {
            this.parts = new String[]{value.getAbsolutePath()};
        }

        public String[] getParts() {
            return this.parts;
        }
    }
}

