/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.shell;

import com.urbancode.shell.CommandLineArg;

public class CompositeCommandLineArg
extends CommandLineArg {
    private String[] valueArray;
    private boolean[] secureArray;

    public CompositeCommandLineArg(String value) {
        super(value);
    }

    public CompositeCommandLineArg(String value, boolean secure) {
        super(value, secure);
    }

    public CompositeCommandLineArg(String[] valueArray) {
        this.valueArray = valueArray;
    }

    public CompositeCommandLineArg(String[] valueArray, boolean[] secureArray) {
        if (valueArray.length != secureArray.length) {
            throw new IllegalArgumentException("Composite value length must match secure identifier length");
        }
        this.valueArray = valueArray;
        this.secureArray = secureArray;
    }

    public String getValue() {
        StringBuffer sb = new StringBuffer("");
        if (this.valueArray != null) {
            for (int i = 0; i < this.valueArray.length; ++i) {
                sb.append(this.valueArray[i]);
            }
        } else {
            sb.append(super.getValue());
        }
        return sb.toString();
    }

    public String getDisplayValue() {
        StringBuffer sb = new StringBuffer("");
        if (this.valueArray != null) {
            for (int i = 0; i < this.valueArray.length; ++i) {
                if (this.secureArray[i]) {
                    sb.append("*****");
                    continue;
                }
                sb.append(this.valueArray[i]);
            }
        } else {
            sb.append(super.getDisplayValue());
        }
        return sb.toString();
    }
}

