/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.shell;

import java.io.InputStream;
import java.io.OutputStream;

public class StreamPump {
    private static final int SIZE = 4096;
    private InputStream source;
    private OutputStream sink;
    private Thread pumpThread = null;
    private Throwable pumpingException = null;
    private volatile boolean done = true;

    public StreamPump(InputStream source, OutputStream sink) {
        this.source = source;
        this.sink = sink;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void doPump() {
        try {
            int bytesRead;
            byte[] buffer = new byte[4096];
            while ((bytesRead = this.source.read(buffer)) != -1) {
                this.sink.write(buffer, 0, bytesRead);
            }
            this.sink.flush();
        }
        catch (Throwable t) {
            this.setPumpingException(t);
        }
        finally {
            this.setDone(true);
            this.notifyAll();
        }
    }

    protected InputStream getSource() {
        return this.source;
    }

    protected OutputStream getSink() {
        return this.sink;
    }

    public final synchronized void pump() {
        if (this.pumpThread != null) {
            throw new IllegalStateException("Pump already running");
        }
        this.pumpThread = Thread.currentThread();
        this.setDone(false);
        this.doPump();
    }

    public final synchronized void pumpAsynchronously() {
        if (this.pumpThread != null) {
            throw new IllegalStateException("Pump already running");
        }
        Runnable asynchronousPump = new Runnable(){

            public void run() {
                StreamPump.this.doPump();
            }
        };
        this.pumpThread = new Thread(asynchronousPump);
        this.setDone(false);
        this.pumpThread.start();
    }

    public final synchronized void waitForCompletion() throws InterruptedException {
        if (this.pumpThread == null) {
            throw new IllegalStateException("Pump not running");
        }
        while (this.isNotDone()) {
            this.wait();
        }
    }

    public final synchronized void waitForCompletion(long millis) throws InterruptedException {
        if (this.pumpThread == null) {
            throw new IllegalStateException("Pump not running");
        }
        while (this.isNotDone()) {
            this.wait(millis);
        }
    }

    public final synchronized void waitForCompletion(long millis, int nanos) throws InterruptedException {
        if (this.pumpThread == null) {
            throw new IllegalStateException("Pump not running");
        }
        while (this.isNotDone()) {
            this.wait(millis, nanos);
        }
    }

    public Throwable getPumpingException() {
        return this.pumpingException;
    }

    protected void setPumpingException(Throwable pumpingException) {
        this.pumpingException = pumpingException;
    }

    public final synchronized void abort() {
        this.setDone(true);
        this.abortCleanup();
        this.notifyAll();
    }

    protected void abortCleanup() {
    }

    protected final boolean isDone() {
        return this.done;
    }

    protected final boolean isNotDone() {
        return !this.isDone();
    }

    protected final void setDone(boolean done) {
        this.done = done;
    }
}

