/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.shell.impersonation;

import java.io.Serializable;

public class ImpersonationToken
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String user;
    private final String group;
    private final String password;
    private final Boolean useSudo;

    public ImpersonationToken(String user) {
        this(user, null);
    }

    public ImpersonationToken(String user, String password) {
        this(user, password, false);
    }

    public ImpersonationToken(String user, String password, Boolean useSudo) {
        this(user, null, password, useSudo);
    }

    public ImpersonationToken(String user, String group, String password, Boolean useSudo) {
        if (user == null) {
            throw new NullPointerException("user");
        }
        if (user.length() == 0) {
            throw new IllegalArgumentException("user cannot be empty");
        }
        this.user = user;
        this.group = group;
        this.password = password;
        this.useSudo = Boolean.TRUE.equals(useSudo);
    }

    public String getUser() {
        return this.user;
    }

    public String getGroup() {
        return this.group;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isUseSudo() {
        return this.useSudo;
    }
}

