/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.shell.impersonation.windows;

import com.urbancode.process.NativeProcess;
import com.urbancode.process.jdk7.ProcessBuilder;
import com.urbancode.shell.impersonation.ImpersonateCommand;
import com.urbancode.shell.impersonation.ImpersonationToken;
import com.urbancode.shell.impersonation.windows.Impersonater;
import com.urbancode.shell.impersonation.windows.ImpersonaterException;
import com.urbancode.shell.impersonation.windows.ImpersonaterStatus;
import com.urbancode.winapi.WindowsUserName;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class WindowsImpersonateCommand
implements ImpersonateCommand {
    private final ImpersonationToken impersonationToken;
    private final List<String> commandLine;
    private final String workDir;
    private final Map<String, String> environment;
    private final ProcessBuilder.Redirect redirectInput;
    private final ProcessBuilder.Redirect redirectOutput;
    private final ProcessBuilder.Redirect redirectError;

    private static Map<String, String> newCaseInsensitiveMap(Map<String, String> map) {
        TreeMap<String, String> result = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        result.putAll(map);
        return result;
    }

    public WindowsImpersonateCommand(ImpersonationToken impersonationToken, List<String> commandLine, String workDir, Map<String, String> environment, ProcessBuilder.Redirect redirectInput, ProcessBuilder.Redirect redirectOutput, ProcessBuilder.Redirect redirectError) {
        ProcessBuilder.Redirect.Type errorType;
        if (impersonationToken == null) {
            throw new NullPointerException("impersonationToken");
        }
        if (commandLine == null) {
            throw new NullPointerException("commandLine");
        }
        if (workDir == null) {
            throw new NullPointerException("workDir");
        }
        if (environment == null) {
            throw new NullPointerException("environment");
        }
        if (redirectInput == null) {
            throw new NullPointerException("redirectInput");
        }
        ProcessBuilder.Redirect.Type inputType = redirectInput.type();
        if (inputType != ProcessBuilder.Redirect.Type.PIPE && inputType != ProcessBuilder.Redirect.Type.READ) {
            throw new IllegalArgumentException("Invalid input redirect");
        }
        if (redirectOutput == null) {
            throw new NullPointerException("redirectOutput");
        }
        ProcessBuilder.Redirect.Type outputType = redirectOutput.type();
        if (outputType != ProcessBuilder.Redirect.Type.PIPE && outputType != ProcessBuilder.Redirect.Type.WRITE && outputType != ProcessBuilder.Redirect.Type.APPEND) {
            throw new IllegalArgumentException("Invalid output redirect");
        }
        if (redirectError != null && (errorType = redirectError.type()) != ProcessBuilder.Redirect.Type.PIPE && errorType != ProcessBuilder.Redirect.Type.WRITE && errorType != ProcessBuilder.Redirect.Type.APPEND) {
            throw new IllegalArgumentException("Invalid error redirect");
        }
        if (commandLine.size() < 1) {
            throw new IllegalArgumentException("commandLine empty");
        }
        this.impersonationToken = impersonationToken;
        this.commandLine = Collections.unmodifiableList(new ArrayList<String>(commandLine));
        this.workDir = workDir;
        this.environment = Collections.unmodifiableMap(WindowsImpersonateCommand.newCaseInsensitiveMap(environment));
        this.redirectInput = redirectInput;
        this.redirectOutput = redirectOutput;
        this.redirectError = redirectError;
    }

    @Override
    public NativeProcess execute() throws IOException {
        Impersonater impersonater = new Impersonater("impersonate");
        impersonater.execute();
        this.configureImpersonater(impersonater);
        ImpersonaterStatus status = impersonater.getStatus();
        if (!status.isOk()) {
            throw new ImpersonaterException(status);
        }
        return impersonater.getProcess();
    }

    private void configureImpersonater(Impersonater impersonater) throws IOException {
        Map<String, String> env = WindowsImpersonateCommand.newCaseInsensitiveMap(this.environment);
        if (!env.containsKey("JAVA_HOME")) {
            env.put("JAVA_HOME", System.getProperty("java.home"));
        }
        WindowsUserName user = WindowsUserName.parse((String)this.impersonationToken.getUser());
        impersonater.setUser(user.getUser());
        impersonater.setDomain(user.getDomain());
        impersonater.setPassword(this.impersonationToken.getPassword());
        impersonater.setWindowStation("winsta0");
        impersonater.setDesktop("default");
        impersonater.setDirectory(this.workDir);
        impersonater.setCommand(null);
        impersonater.setCommandLine(this.commandLine);
        impersonater.setEnvironment(env);
        impersonater.setInput(this.redirectInput);
        impersonater.setOutput(this.redirectOutput);
        impersonater.setError(this.redirectError);
        impersonater.configurationComplete();
    }
}

