import com.urbancode.air.AirPluginTool
final def workDir = new File('.').canonicalFile

def apTool = new AirPluginTool(args[0], args[1])
final def props = apTool.getStepProperties()

def rtcpServerURL = props['serverURL'];
println "rtcpServerURL : " + rtcpServerURL;
def domain = props['domain'];
println "domain: " + domain;
def environment = props['environment'];
println "environment: " + environment;
def stubName = props['stubname'];
println "Stub name: " + stubName;
def stubVersion = props['version'];
println "Stub version: " + stubVersion;
def component = props['component'];
println "Component: " + component;
def operation = props['operation'];
println "Operation: " + operation;
def username = props['username'];
println "username: " + username;
def agentAttributes = props['agentAttributes'];
println "agentAttributes: " + agentAttributes;
def PLUGIN_HOME = System.getenv("PLUGIN_HOME");


def pluginHomeFile = new File(PLUGIN_HOME);
if (!pluginHomeFile.exists()) {
    throw new RuntimeException("Cannot get PLUGIN_HOME");
}

def libDir = new File(pluginHomeFile, "lib");
if (!libDir.exists()) {
    throw new RuntimeException("Cannot get lib directory!");
}

def ant = new AntBuilder();

try {
    ant.path(id:"gh.classpath") {
      fileset(dir:libDir) {
          include(name:"*.jar")
      }
    }
    
    ant.taskdef(name:"startStub", classname:"com.ghc.ghTester.ant.StartStub", classpathref:"gh.classpath")
	
	// Required args
	def startStubArgs = [serverURL:"${rtcpServerURL}",
            name:"${stubName}",
            domain:"${domain}",
            environment:"${environment}",
            failureProperty: "taskFailed"]

	// Optional args
	if (component != null && component.trim().length() > 0) {
		startStubArgs.put("component", "${component}")
	}	
	if (operation != null && operation.trim().length() > 0) {
		startStubArgs.put("operation", "${operation}")
	}	
	if (agentAttributes != null && agentAttributes.trim().length() > 0) {
		startStubArgs.put("attributes", "${agentAttributes}")
	}	
	if (username != null && username.trim().length() > 0) {
		startStubArgs.put("username", "${username}")
	}

	// Execute task - capture version of stub if one not specified
    if (stubVersion != null && stubVersion.trim().length() > 0) {
      startStubArgs.put("version", "${stubVersion}")
      ant.startStub(startStubArgs)
    }  
    else {
	  startStubArgs.put("versionProperty", "stubver")
	  ant.startStub(startStubArgs)
      stubVersion = ant.project.properties.stubver
    }            
    
    if (ant.project.properties.taskFailed == "true")
    {
      System.out.println("startStub task failed!");
      System.exit(1);
    }
    else
    {
	  // Write version of stub started to output properties file (useful if stubVersion not specified)
      System.out.println("Successfully started stub version: " + stubVersion);	  
	  apTool.setOutputProperty("stubVersionStarted", stubVersion);
	  apTool.setOutputProperties();
    }

}
catch (Exception e) {
    System.out.println("Error starting stub!");
    e.printStackTrace();
    System.exit(1);
}
