/*
* Licensed Materials - Property of IBM* and/or HCL**
* UrbanCode Deploy
* UrbanCode Build
* UrbanCode Release
* AnthillPro
* (c) Copyright IBM Corporation 2013, 2017. All Rights Reserved.
* (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*
* * Trademark of International Business Machines
* ** Trademark of HCL Technologies Limited
*/
import com.urbancode.air.CommandHelper
import com.urbancode.air.AirPluginTool

final def workDir = new File('.').canonicalFile
final def airTools = new AirPluginTool(args[0], args[1])
final def props = airTools.getStepProperties()

def cmd = props['cmd']
def commandPath = props['commandPath']
def cscriptPath = props['cscriptPath']
def path = props['path']
def parameters = props['parameters']
if (!commandPath || commandPath.trim().length() == 0) {
    commandPath = "C:\\InetPub\\AdminScripts\\adsutil.vbs"
}

println "adsutil.vbs path: $commandPath"
if (!new File(commandPath).exists()) {
    println "Cannot locate adsutil.vbs script!"
    System.exit 1
}

if (!cscriptPath || cscriptPath.trim().length() == 0) {
    cscriptPath = "C:\\Windows\\system32\\cscript.exe"
    if (!new File(cscriptPath).exists()) {
        cscriptPath = "C:\\Windows\\SysWOW64\\cscript.exe"
        if (!new File(cscriptPath).exists()) {
            println "Cannot locate cscript.exe executable!"
            System.exit 1
        }
    }
}
println "cscript path: $cscriptPath"
println "path: $path"
println "parameters: ${parameters.split('[\r\n]').join(' ')}"

def args = [cscriptPath, commandPath, cmd]

if (path && path.trim().length() > 0) {
   args << path
}

if (parameters && parameters.trim().length() > 0) {
    parameters.split('[\r\n]').each {
        if (it && it.trim().length() > 0) {
            args << it.trim()
        }
    }
}

def commandHelper = new CommandHelper(workDir);
commandHelper.runCommand('Executing adsutil', args);
