/*
* Licensed Materials - Property of IBM* and/or HCL**
* UrbanCode Deploy
* UrbanCode Build
* UrbanCode Release
* AnthillPro
* (c) Copyright IBM Corporation 2013, 2017. All Rights Reserved.
* (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*
* * Trademark of International Business Machines
* ** Trademark of HCL Technologies Limited
*/
import java.util.regex.Pattern;
import java.util.regex.Matcher;

import com.urbancode.air.AirPluginTool
import com.urbancode.air.CommandHelper

final AirPluginTool airPluginTool = new AirPluginTool(this.args[0], this.args[1])
final Properties props = airPluginTool.getStepProperties()

final def workDir = new File('.').canonicalFile

def cmd = 'SET';
def website = props['path'];
def iiswebPath = "C:\\Windows\\system32\\iisweb.vbs";
def version = props['version']
def regiisPath = "C:\\Windows\\microsoft.net\\framework\\${version}\\aspnet_regiis.exe";

def cscriptExe = "cscript.exe"

def ch = new CommandHelper(new File('.'));

def args = [];

args = [cscriptExe, iiswebPath, '/query', "${website}"];

OutputStream oStream = new ByteArrayOutputStream();
PrintStream stream = new PrintStream(oStream);
ch.runCommand(args.join(' '), args) { proc ->
    try {
        proc.waitForProcessOutput(stream, System.out);
    }
    finally {
       stream.flush();
    }
}

//now we need to parse out the actual path to the website
BufferedReader input = new BufferedReader(new StringReader(oStream.toString()));
Pattern pat = Pattern.compile("^" + website + " \\((.*)\\).*");
String line;
while ((line = input.readLine()) != null) {
    Matcher matcher = pat.matcher(line);
    if (matcher.matches()) {
        break;
    }
}
Matcher matcher = pat.matcher(line);

if (!matcher.find()) {
    throw new RuntimeException("Website not found!");
}

def websitePath = matcher.group(1);

def cmdArs = [];
cmdArgs = [regiisPath, '-s'];
cmdArgs << websitePath + "/ROOT";
ch.runCommand(cmdArgs.join(' '), cmdArgs);
