/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import java.util.regex.Pattern;
import java.util.regex.Matcher;

import com.urbancode.air.AirPluginTool
import com.urbancode.air.CommandHelper

final AirPluginTool airPluginTool = new AirPluginTool(this.args[0], this.args[1])
final Properties props = airPluginTool.getStepProperties()

final def workDir = new File('.').canonicalFile

def cmd = 'SET';
def website = props['path'];
def adsPath = "C:\\InetPub\\AdminScripts\\adsutil.vbs";
def iiswebPath = "C:\\Windows\\system32\\iisweb.vbs";
def parameters = (props['parameters']?props['parameters'].split('\n'):null);

def cscriptExe = "cscript.exe"

def ch = new CommandHelper(new File('.'));

def args = [];

args = [cscriptExe, iiswebPath, '/query', "${website}"];

OutputStream oStream = new ByteArrayOutputStream();
PrintStream stream = new PrintStream(oStream);
ch.runCommand(args.join(' '), args) { proc ->
    try {
        proc.waitForProcessOutput(stream, System.out);
    }
    finally {
       stream.flush();
    }
}

//now we need to parse out the actual path to the website
BufferedReader input = new BufferedReader(new StringReader(oStream.toString()));
Pattern pat = Pattern.compile("^" + website + " \\((.*)\\).*");
String line;
while ((line = input.readLine()) != null) {
    Matcher matcher = pat.matcher(line);
    if (matcher.matches()) {
        break;
    }
}
Matcher matcher = pat.matcher(line);

if (!matcher.find()) {
    throw new RuntimeException("Website not found!");
}

def websitePath = matcher.group(1);

parameters.each { parameter ->
    def name = parameter.split('=',2)[0];
    def value = parameter.split('=',2)[1];
    println "Setting attibute ${websitePath}/${name} to ${value}"

    def cmdArs = [];
    cmdArgs = [cscriptExe, adsPath, cmd];
    cmdArgs << websitePath + "/" + name;
    cmdArgs << value;
    ch.runCommand(cmdArgs.join(' '), cmdArgs);
}
