/*
* Licensed Materials - Property of IBM* and/or HCL**
* UrbanCode Deploy
* UrbanCode Build
* UrbanCode Release
* AnthillPro
* (c) Copyright IBM Corporation 2013, 2017. All Rights Reserved.
* (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*
* * Trademark of International Business Machines
* ** Trademark of HCL Technologies Limited
*/
package com.urbancode.air.plugin.iisappcmd

public class CustomPrintStream extends PrintStream {

    def padding

    CustomPrintStream(PrintStream out, int padding) {
        super(out)
        this.out = out
        this.padding = padding
    }

    public void println(String line) {
        out.println line.padLeft(line.size() + padding, ' ')
    }
}

public static def checkIfAppExists(appName, appcmd, commandHelper) {
    def result = false
    if (appName && appName.trim().length() > 0) {
        def app = appName.trim()
        println "        -------------------------------------------------------"
        println "        Check if app $app exists"
        def command = [appcmd, 'list', 'app', app]
        def curSysOut = System.out
        System.setOut(new CustomPrintStream(curSysOut, 12))

        try {
            commandHelper.runCommand(null, command) { proc ->
                proc.out.close()

                proc.in.eachLine{ line ->
                    if (line != null && line.trim().length() > 0 && line.toLowerCase().indexOf(appName.toLowerCase()) != -1) {
                        println "app exists!"
                        result = true
                    }
                }
            }
        }
        catch (Exception e) {
            println e.message
        }
        finally {
            System.setOut(curSysOut)
        }
    }
    if (!result) {
        println "        app does not exist!"
    }

    return result
}

public static def createApp(appName, appType, File appFile, appcmd, commandHelper) {
    def result = true
    if (appName && appName.trim().length() > 0) {
        def app = appName.trim()
        println "        -------------------------------------------------------"
        println "        Creating $app"
        def command = [appcmd, 'add', appType, '/in']
        def curSysOut = System.out
        System.setOut(new CustomPrintStream(curSysOut, 12))

        try {
            commandHelper.runCommand(null, command) { Process proc ->
                proc.out.withWriter { writer ->
                    appFile.eachLine { line ->
                        writer.println line
                    }
                }

                proc.out.close()
                proc.consumeProcessOutput(System.out, System.err)
            }
        }
        catch (Exception e) {
            println e.message
            result = false
        }
        finally {
            System.setOut(curSysOut)
        }
    }
    if (result) {
        println "        created successfully!"
    }
    else {
        println "        failed!"
    }
    return result
}

public static def updateApp(appName, appType, File appFile, appcmd, commandHelper) {
    def result = true
    if (appName && appName.trim().length() > 0) {
        def app = appName.trim()
        println "        -------------------------------------------------------"
        println "        Updating $app"
        def command = [appcmd, 'set', appType, '/in']
        def curSysOut = System.out
        System.setOut(new CustomPrintStream(curSysOut, 12))

        try {
            commandHelper.runCommand(null, command) { Process proc ->
                proc.out.withWriter { writer ->
                    appFile.eachLine { line ->
                        writer.println line
                    }
                }

                proc.out.close()
                proc.consumeProcessOutput(System.out, System.err)
            }
        }
        catch (Exception e) {
            println e.message
            result = false
        }
        finally {
            System.setOut(curSysOut)
        }
    }

    if (result) {
        println "        updated successfully!"
    }
    else {
        println "        update failed!"
    }

    return result
}

public static def checkIfAppPoolExists(appPoolName, appcmd, commandHelper) {
    def result = true
    if (appPoolName && appPoolName.trim().length() > 0) {
        def appPool = appPoolName.trim()
        println "        -------------------------------------------------------"
        println "        Check if application pool $appPool exists"
        def command = [appcmd, 'list', 'apppool', appPool];

        def curSysOut = System.out
        System.setOut(new CustomPrintStream(curSysOut, 12))
        try {
            commandHelper.runCommand(null, command) { Process proc ->
                proc.out.close()
                proc.consumeProcessOutput(System.out, System.out)
            }
        }
        catch (Exception e) {
            println e.message
            result = false
        }
        finally {
            System.setOut(curSysOut)
        }
    }
    if (result) {
        println "        application pool exists!"
    }
    else {
        println "        application pool does not exit!"
    }

    return result
}

