/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2016. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.CommandHelper
import com.urbancode.air.AirPluginTool

final AirPluginTool airPluginTool = new AirPluginTool(this.args[0], this.args[1])
final Properties props = airPluginTool.getStepProperties()

final def workDir = new File('.').canonicalFile

def cmd = props['cmd'];
def type = props['type'];
def id = props['id'];
def commandPath = props['commandPath']
def argStrings = (props['argString']?props['argString'].split('\n'):null);

def ch = new CommandHelper(new File('.'));

def args = [];
args = [commandPath + 'appcmd.exe', cmd, type];
if(id) {
    args << id;
}
argStrings.each { arg ->
     args << arg;
}
ch.runCommand(args.join(' '), args);
