/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util;

import com.urbancode.commons.util.ArrayUtil;
import com.urbancode.commons.util.Check;
import java.lang.reflect.Array;
import java.util.Date;

public final class ObjectUtil {
    public static boolean isEqual(Object obj1, Object obj2) {
        return obj1 == obj2 || obj1 != null && obj1.equals(obj2);
    }

    public static <T extends Comparable<T>> int compare(T obj1, T obj2) {
        if (obj1 == obj2) {
            return 0;
        }
        if (obj1 == null) {
            return -1;
        }
        if (obj2 == null) {
            return 1;
        }
        return obj1.compareTo(obj2);
    }

    public static Date clone(Date date) {
        return date == null ? null : (Date)date.clone();
    }

    public static String[] clone(String[] array) {
        return ArrayUtil.copy(array);
    }

    public static <U, T> T[] copyOf(U[] original, int newLength, Class<? extends T[]> newType) {
        Check.nonNull(original, "original");
        Check.nonNull(newType, "newType");
        if (!newType.isArray()) {
            throw new IllegalArgumentException("New type must be an array");
        }
        Class<?> newComponentType = newType.getComponentType();
        int originalLength = original.length;
        Object[] result = (Object[])Array.newInstance(newComponentType, newLength);
        System.arraycopy(original, 0, result, 0, Math.min(originalLength, newLength));
        return result;
    }

    public static String findLoadedClass(Class<?> clazz) {
        return String.valueOf(clazz.getResource(clazz.getSimpleName() + ".class"));
    }

    private ObjectUtil() {
    }
}

