/*
* Licensed Materials - Property of IBM* and/or HCL**
* UrbanCode Deploy
* UrbanCode Build
* UrbanCode Release
* AnthillPro
* (c) Copyright IBM Corporation 2013, 2017. All Rights Reserved.
* (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*
* * Trademark of International Business Machines
* ** Trademark of HCL Technologies Limited
*/
import com.urbancode.air.CommandHelper
import com.urbancode.air.AirPluginTool

final AirPluginTool airPluginTool = new AirPluginTool(this.args[0], this.args[1])
final Properties props = airPluginTool.getStepProperties()

final def workDir = new File('.').canonicalFile

def siteName = props['siteName'];
def commandPath = props['commandPath']
def argStrings = (props['argString']?props['argString'].split('\n'):null);

long timeout = props['timeout']?(long) Double.parseDouble(props['timeout']?.trim()):1

println "[Ok] Setting timeout to ${timeout} seconds."

def ch = new CommandHelper(new File('.'));

def args = [];
args = [commandPath + 'appcmd.exe', 'stop', 'site', siteName];
argStrings.each { arg ->
     args << arg;
}
ch.runCommand(args.join(' '), args, timeout);
