/*
* Licensed Materials - Property of IBM* and/or HCL**
* UrbanCode Deploy
* UrbanCode Build
* UrbanCode Release
* AnthillPro
* (c) Copyright IBM Corporation 2013, 2017. All Rights Reserved.
* (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*
* * Trademark of International Business Machines
* ** Trademark of HCL Technologies Limited
*/
import com.urbancode.air.CommandHelper
import com.urbancode.air.AirPluginTool
import com.urbancode.air.plugin.iisappcmd.ConfigHelper


final def workDir = new File('.').canonicalFile
final def airTool = new AirPluginTool(args[0], args[1])
final def props = airTool.getStepProperties()


def appName = props['appName']?.trim()
def appXml = props['appXml']
def appXmlFile = props['appXmlFile']
def commandPath = new File(props['commandPath'].trim() as String, 'appcmd.exe').canonicalPath

println "Application name: $appName"
println "Application XML provided: ${appXml?'true':'false'}"
println "Application XML File: ${appXmlFile?:''}"
println "AppCmd command path: ${commandPath?:''}"
println "---------------------------------------------------------"


if (appName?.trim()?.length() == 0) {
    println "Application name is required!"
    System.exit 1
}

if (appXml?.trim()?.length() == 0 && appXmlFile?.trim()?.length() == 0) {
    println "No application configuration provided, nothing to do!"
}
else {
    try {
        def file
        if (appXml?.trim()?.length() > 0) {
            file = File.createTempFile('ud-appcmd', '.xml')
            file.withWriter {writer ->
                writer << appXml
            }
        }
        else {
            file = new File(appXmlFile)
            if (!file.exists()) {
                "${file.canoninicalPath} does not exist!"
                System.exit 1
            }
        }

        def commandHelper = new CommandHelper(workDir)

        if (ConfigHelper.checkIfAppExists(appName, commandPath, commandHelper)) {
            if (!ConfigHelper.updateApp(appName, 'app', file, commandPath, commandHelper)) {
                System.exit 1
            }
        }
        else {
            if (!ConfigHelper.createApp(appName, 'app', file, commandPath, commandHelper)) {
                System.exit 1
            }
        }
    }
    catch (Exception e) {
        e.printStackTrace()
        System.exit 1
    }
}
