/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.deploy.common;

import com.ibm.urbancode.zos.deploy.common.ContainerMapperParser;
import com.ibm.urbancode.zos.deploy.common.DataSet;
import com.ibm.urbancode.zos.deploy.common.Member;
import com.ibm.urbancode.zos.deploy.common.PackageManifestParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentResultHelper {
    private static final String packageManifestFileName = "packageManifest.xml";
    private static final String additionalFolder4BasePath = "deploy";
    private static final String containerMapperFileName = "containerMapper.xml";

    public static Set<DataSet> getDeployedDataSets(String deployBasePath, String componentName, String versionName) throws IOException, XMLStreamException {
        Set<DataSet> deployedDatasets = null;
        InputStream rollbackInputStream = null;
        Map<String, String> rulerMapper = null;
        try {
            rollbackInputStream = new FileInputStream(DeploymentResultHelper.getDeployMetaFilePath(deployBasePath, componentName, versionName, packageManifestFileName));
            deployedDatasets = PackageManifestParser.parseDeployedDatasets(rollbackInputStream);
            rulerMapper = DeploymentResultHelper.getDeployContainerMapper(deployBasePath, componentName, versionName);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw fileNotFoundException;
        }
        finally {
            if (null != rollbackInputStream) {
                rollbackInputStream.close();
            }
        }
        for (DataSet currentDeployedDataSet : deployedDatasets) {
            String currentTargetDsName = rulerMapper.get(currentDeployedDataSet.getName());
            currentDeployedDataSet.setName(currentTargetDsName);
            for (Member member : currentDeployedDataSet.getMembers()) {
                member.setDataSetName(currentTargetDsName);
            }
        }
        return deployedDatasets;
    }

    public static Set<Member> getMembersByDeployType(String deployBasePath, String componentName, String versionName, String deployType) throws IOException, XMLStreamException {
        Set<Member> deployedMembers = null;
        InputStream pacakgeManifestFileInputStream = null;
        Map<String, String> rulerMapper = null;
        try {
            pacakgeManifestFileInputStream = new FileInputStream(DeploymentResultHelper.getDeployMetaFilePath(deployBasePath, componentName, versionName, packageManifestFileName));
            deployedMembers = PackageManifestParser.parseMembersByDeployType(pacakgeManifestFileInputStream, deployType);
            rulerMapper = DeploymentResultHelper.getDeployContainerMapper(deployBasePath, componentName, versionName);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw fileNotFoundException;
        }
        finally {
            if (null != pacakgeManifestFileInputStream) {
                pacakgeManifestFileInputStream.close();
            }
        }
        for (Member currentMember : deployedMembers) {
            currentMember.setDataSetName(rulerMapper.get(currentMember.getDataSetName()));
        }
        return deployedMembers;
    }

    private static Map<String, String> getDeployContainerMapper(String deployBasePath, String componentName, String versionName) throws IOException, XMLStreamException {
        FileInputStream containerMapperInputStream = null;
        containerMapperInputStream = new FileInputStream(DeploymentResultHelper.getDeployMetaFilePath(deployBasePath, componentName, versionName, containerMapperFileName));
        return ContainerMapperParser.parseDeployRulerMapper(containerMapperInputStream);
    }

    private static String getDeployMetaFilePath(String deployBasePath, String componentName, String versionName, String fileName) {
        String metaFilePath = deployBasePath + File.separator + additionalFolder4BasePath + File.separator + componentName + File.separator + versionName + File.separator + fileName;
        File file = new File(metaFilePath);
        if (!file.exists() || !file.isFile()) {
            throw new IllegalArgumentException(metaFilePath + " not found, please make sure the version has been successfully deployed");
        }
        return metaFilePath;
    }
}

