/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2014. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import java.util.Map;

import com.urbancode.air.AirPluginTool

import static java.lang.Integer.valueOf

import com.ibm.urbancode.zos.jes.JESJob;
import com.ibm.urbancode.zos.jes.JobUtil;
import com.ibm.jzos.PdsDirectory;
import com.ibm.jzos.ZFile;
import com.ibm.jzos.ZUtil;
import com.ibm.jzos.CatalogSearch;
import com.ibm.jzos.ZFileException;
import com.ibm.jzos.RecordReader;
import com.ibm.jzos.ZFileConstants;

try{
	def apTool = new AirPluginTool(this.args[0], this.args[1])
	final def workDir = new File('.').canonicalFile
	def props = apTool.getStepProperties();
	final def inputPropsFile = new File(args[0]);

	final def imsCommand = props['imsCommand']?.trim();
	final def imsPlex = props['imsPlex']?.trim();
	final def imsId = props['imsId']?.trim();
	final def imsReslib = props['imsReslib']?.trim();
	//final def explicitTokens = props['explicitTokens']?.trim();
	final def waitForCommand = Boolean.valueOf(props['waitForCommand']);
	
	final def timeout = props['timeout']?.trim();
	final def showOutput = props['showOutput']?.trim();
	final def cutOff = props['cutOff']?.trim();
	final def maxRC = props['maxRC']?.trim();

	final def jclclass = props['class']?.trim();
	
	final def hostname = props['hostname']?.trim();
	final def userid = props['userid']?.trim();
	final def password = props['password']?.trim();
	final def port = props['port']?.trim();

	if(!imsCommand || imsCommand.length() < 1){
		throw new IllegalArgumentException("IMS Command can not be empty.");
	}
	if(!imsPlex || imsPlex.length() < 1){
		throw new IllegalArgumentException("IMS PLEX can not be empty.");
	}
	if(!imsId || imsId.length() < 1){
		throw new IllegalArgumentException("IMS ID can not be empty.");
	}
	if(!imsReslib || imsReslib.length() < 1){
		throw new IllegalArgumentException("IMS RESLIB can not be empty.");
	}
	
	if(!hostname || hostname.length() < 1){
		throw new IllegalArgumentException("Host Name can not be empty.");
	}
	if(!userid || userid.length() < 1){
		throw new IllegalArgumentException("User ID can not be empty.");
	}
	if(!password || password.length() < 1){
		throw new IllegalArgumentException("Password can not be empty.");
	}
	if(!port || port.length() < 1){
		throw new IllegalArgumentException("Port can not be empty.");
	}
	
	def jclString = 
		"//IMSCMD JOB ,\n" +                                  
		"//   CLASS=" + jclclass + ",MSGCLASS=H,NOTIFY=" + userid + ",USER=" + userid + "\n" +                     
		"//SPOC      EXEC PGM=CSLUSPOC,\n" +                     
		"//  PARM=('IMSPLEX=" + imsPlex + ",ROUTE=" + imsId + ",WAIT=30')\n" +     
		"//STEPLIB   DD DISP=SHR,DSN=" + imsReslib + "\n" +
		"//SYSPRINT  DD SYSOUT=*\n" +                            
		"//SYSIN     DD *\n" +                                   
		imsCommand + "\n" +                                 
		"/*EOF";
	
	def jobUtil = new JobUtil(hostname,port,userid,password)
	
	if(jclString && jclString.length() > 0){
		jobUtil.setJclString(jclString);
	}else{
		throw new IllegalArgumentException("At least one JCL input (JCL Dataset, JCL File or JCL) must be specified. ");
	}

	if(waitForCommand){
		try{
			int timeoutValue = valueOf(timeout as String);
			jobUtil.setTimeout(timeoutValue);
		}catch(NumberFormatException e){
			throw new IllegalArgumentException("Time Out isn't a number.");
		}
		try{
			int cutOffValue = valueOf(cutOff as String);
			jobUtil.setCutoff(cutOffValue);
		}catch(NumberFormatException e){
			throw new IllegalArgumentException("Cut Off isn't a number.");
		}		
		try{
			int maxRCValue = valueOf(maxRC as String);
			jobUtil.setMaxReturnCode(maxRCValue);
		}catch(NumberFormatException e){
			throw new IllegalArgumentException("Max Return Code isn't a number.");
		}		
		jobUtil.setShowOutput(showOutput);		
	}
	
//	if(explicitTokens && explicitTokens.length() >0){
//		// replace tokens
//		jobUtil.setJclString(replaceJCL(jobUtil.getJclString(),explicitTokens));
//	}
	
	def jobid = jobUtil.submitJob();
	
	apTool.setOutputProperty("JobId", jobid);
	//wait before check JCL Error
	Thread.sleep(500);
	
	if(jobUtil.isJclError(jobid)){
		def job = jobUtil.getJob(jobid, true);
		apTool.setOutputProperty("JobReturnCode", job.getReturnCode()==null?"":job.getReturnCode());
		apTool.setOutputProperty("JobReturnInfo", job.getReturnInfo()==null?"":job.getReturnInfo());
		apTool.setOutputProperty("JobReturnStatus", job.getReturnStatus()==null?"":job.getReturnStatus());
		
		jobUtil.disconnect();

		apTool.storeOutputProperties();
		System.exit(1);
	}
	
	if(waitForCommand){
		def success = jobUtil.waitForJob(jobid);
		jobUtil.printLog(jobid);

		def job = jobUtil.getJob(jobid, true);
		apTool.setOutputProperty("JobReturnCode", job.getReturnCode()==null?"":job.getReturnCode());
		apTool.setOutputProperty("JobReturnInfo", job.getReturnInfo()==null?"":job.getReturnInfo());
		apTool.setOutputProperty("JobReturnStatus", job.getReturnStatus()==null?"":job.getReturnStatus());
		apTool.storeOutputProperties();

		jobUtil.disconnect();
		if(success){
			System.exit(0);
		}else{
			System.exit(1);
		}
	}else{
		apTool.storeOutputProperties();
	}
}catch (Exception e) {
    println "Error Running Job: ${e.message}";
	e.printStackTrace();
    System.exit(1);
}

def replaceJCL(String jcl, String rules){
	//Write rules into properties file
	def Properties properties = new Properties();
    rules.eachLine {
        if (it && it.indexOf('->') > 0) {
            def index = it.indexOf('->')
            def propName = it.substring(0, index).trim()
            def propValue = index < (it.length() - 2) ? it.substring(index + 2) : ""
            properties.setProperty(propName, propValue)
//            println 'added: ' + propName + ':' + propValue
        }
        else if (it) {
            println "Found invalid explicit token $it - missing -> separator"
			System.exit(1);
        }
    }
	def propFile = new File(".", "tmppropFile")
	propFile.withOutputStream { outStream ->
	    properties.store(outStream, 'Auto generated property file')
	}

	// Write data set content into a temp file
	File f= new File(".","tmpmvsfile");
	f.deleteOnExit();
	PrintWriter pw = new PrintWriter(f);
	pw.println(jcl);
	pw.close();

	//Run ant replace
	def ant = new AntBuilder()
	String encode = ZUtil.getDefaultPlatformEncoding();
	ant.replace(
		file:f.canonicalPath,
		summary: 'true',
		defaultexcludes: 'no',
		replacefilterfile: propFile.canonicalPath,
		encoding: encode)
	f = new File(".","tmpmvsfile");
	String targetJcl =f.text;
	f.delete();
	propFile.delete();
	
	println "========================================================================================================================"
	println "JCL after replacing tokens."
	//check for exceeding 80
	def lines=targetJcl.split("\n")
	def i = 1
	byte[] recBuf = null;
	
	for(line in lines){
		recBuf =line.getBytes(ZUtil.getDefaultPlatformEncoding())
		if(recBuf.length > 80){
			println "Warning: line $i excceeds 80 bytes and will be truncated."
			println " $i: $line"
		}
		i++
	}
	println "========================================================================================================================"
	println (targetJcl);
	
	
	return targetJcl;
}

System.exit(0);

